/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenError;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import org.apache.commons.codec.binary.Base64;

public final class TokenParser {
    public static final String ROLE_FIELD = "role";
    public static final String CUSTOMER_ID_FIELD = "customerId";
    public static final String SERVER_FIELD = "server";
    private static final int NUMBER_OF_IWJT_TOKEN_PARTS = 3;
    private static final String SPLIT_BY = "\\.";

    public static TokenData parseAndValidate(String rawToken) {
        TokenData tokenData = TokenParser.parse(rawToken);
        TokenParser.validateData(tokenData);
        return tokenData;
    }

    public static TokenData parse(String rawToken) {
        try {
            if (StringUtils.isNullOrEmpty(rawToken)) {
                return TokenParser.createNullTokenData(null);
            }
            String[] parts = rawToken.split(SPLIT_BY);
            TokenParser.parseParts(rawToken, parts);
            rawToken = parts[1];
            byte[] bytes = Base64.decodeBase64((String)rawToken);
            String tokenAsJson = new String(bytes);
            ObjectMapper mapper = new ObjectMapper();
            TokenData tokenData = (TokenData)mapper.readValue(tokenAsJson, TokenData.class);
            if (tokenData != null) {
                return tokenData;
            }
        }
        catch (Exception e) {
            return TokenParser.createNullTokenData(e.getMessage());
        }
        return TokenParser.createNullTokenData(null);
    }

    public static TokenData validateData(TokenData tokenData) {
        if (tokenData == null) {
            return TokenParser.createNullTokenData(null);
        }
        if (!tokenData.isValid()) {
            return tokenData;
        }
        String role = tokenData.getRole();
        if (StringUtils.isNullOrEmpty(role)) {
            tokenData.addError(new TokenError(ROLE_FIELD, "is empty"));
        } else if (!role.equals("agent")) {
            tokenData.addError(new TokenError(ROLE_FIELD, "Expected role: 'agent'. Actual role: '" + tokenData.getRole() + "'"));
        }
        if (StringUtils.isNullOrEmpty(tokenData.getCustomerId())) {
            tokenData.addError(new TokenError(CUSTOMER_ID_FIELD, "is empty"));
        }
        if (StringUtils.isNullOrEmpty(tokenData.getServer())) {
            tokenData.addError(new TokenError(SERVER_FIELD, "is empty"));
        }
        return tokenData;
    }

    private static TokenData createNullTokenData(String error) {
        TokenData tokenData = new TokenData();
        TokenError tokenError = new TokenError(error != null ? error : "token is empty");
        tokenData.addError(tokenError);
        return tokenData;
    }

    private static void parseParts(String token, String[] parts) {
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Invalid token: contains %d parts instead of %d; token:%s", parts.length, 3, token));
        }
        token = parts[1];
        if (!Base64.isBase64((String)token)) {
            throw new IllegalArgumentException("Token is not a valid Base64 string; token:" + token);
        }
    }

    private TokenParser() {
    }
}

