/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.upgrade;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.types.Component;
import io.sealights.onpremise.agents.infra.version.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;

class ComponentJarOrganizer {
    private static final Logger LOGGER = LogFactory.getLogger(ComponentJarOrganizer.class);
    static final int VERSIONS_HISTORY_TO_SAVE_BESIDE_RECOMMENDED = 2;

    ComponentJarOrganizer() {
    }

    public void rearrangeJars(String jarsFolder) {
        File folder = new File(jarsFolder);
        File[] filesInFolder = folder.listFiles();
        if (filesInFolder == null) {
            LOGGER.warn("Unable to rearrange the cache folder since 'filesInFolder' is null.");
            return;
        }
        TreeMap<Version, List<File>> versions = this.sortByVersions(filesInFolder);
        if (versions.size() > 2) {
            this.deleteOlderVersions(versions);
        }
    }

    public void tryDeleteFile(File oldAgent, String descriptor) {
        try {
            if (oldAgent.delete()) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete " + descriptor + ": '" + oldAgent.getAbsolutePath() + "'. Error: '" + e.getMessage() + "'.");
        }
    }

    private void deleteOlderVersions(TreeMap<Version, List<File>> versions) {
        versions = this.filterVersionsToDelete(versions);
        for (Map.Entry<Version, List<File>> pair : versions.entrySet()) {
            List<File> agentsToDelete = pair.getValue();
            for (File agent : agentsToDelete) {
                this.tryDeleteFile(agent, "old agent");
            }
        }
    }

    private TreeMap<Version, List<File>> sortByVersions(File[] filesInFolder) {
        TreeMap<Version, List<File>> versionsTree = new TreeMap<Version, List<File>>();
        for (File f : filesInFolder) {
            String detectedVersion;
            boolean isAgentJar;
            if (f == null || !f.isFile()) continue;
            String filename = f.getName();
            boolean bl = isAgentJar = filename.startsWith("sl-") && filename.endsWith(".jar");
            if (!isAgentJar || !Version.isValidVersion(detectedVersion = this.detectVersionFromAgentFileName(filename))) continue;
            Version v = new Version(detectedVersion);
            this.addToVersionsTree(versionsTree, v, f);
        }
        return versionsTree;
    }

    private TreeMap<Version, List<File>> filterVersionsToDelete(TreeMap<Version, List<File>> versions) {
        for (int i = 0; i < 2; ++i) {
            versions.remove(versions.lastKey());
        }
        return versions;
    }

    private String detectVersionFromAgentFileName(String fileName) {
        fileName = fileName.replace(Component.BUILD_SCANNER_COMPONENT_NAME.getComponentArtifact() + "-", "");
        fileName = fileName.replace(Component.TEST_LISTENER_COMPONENT_NAME.getComponentArtifact() + "-", "");
        return fileName.replace(".jar", "");
    }

    private void addToVersionsTree(TreeMap<Version, List<File>> versionsTree, Version version, File agent) {
        List<File> listToAdd = this.lookVersionInTree(versionsTree, version);
        if (listToAdd != null) {
            listToAdd.add(agent);
        } else {
            ArrayList<File> filesRelatedToVersion = new ArrayList<File>();
            filesRelatedToVersion.add(agent);
            versionsTree.put(version, filesRelatedToVersion);
        }
    }

    private List<File> lookVersionInTree(TreeMap<Version, List<File>> versionsTree, Version version) {
        for (Version v : versionsTree.keySet()) {
            if (!v.equals(version)) continue;
            return versionsTree.get(v);
        }
        return null;
    }
}

