/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.upgrade;

import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.jarutils.ArchiveUtils;
import io.sealights.onpremise.agents.infra.jarutils.JarReader;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.version.AgentInfo;
import io.sealights.onpremise.agents.infra.serviceproxy.version.GetVersionResponse;
import io.sealights.onpremise.agents.infra.serviceproxy.version.VersionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.version.VersionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.types.Component;
import io.sealights.onpremise.agents.infra.upgrade.ComponentJarOrganizer;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.version.Version;
import java.io.File;
import java.util.jar.JarFile;
import lombok.Generated;
import org.slf4j.Logger;

public class ComponentUpgrader {
    private static final Logger LOGGER = LogFactory.getLogger(ComponentUpgrader.class);
    public static final String CORE_AGENTS_RELATIVE_CACHE_FOLDER = "core-agents";
    public static final String MAVEN_PLUGIN_AGENTS_RELATIVE_CACHE_FOLDER = "maven-plugin";
    public static final String SL_RELATIVE_CACHE_FOLDER = "sl-cache";
    public static final String DOT_JAR = ".jar";
    public static final String DOT_ZIP = ".zip";
    private static final String SNAPSHOT = "SNAPSHOT";
    private JarReader jarReader = new JarReader();
    private final UpgradeConfiguration upgradeConfiguration;
    private final Component component;
    private final String componentSubFolder;
    private final UpgradeMode upgradeMode;
    private String embeddedVersion;
    private VersionServiceProxy versionServiceProxy;

    public ComponentUpgrader(Component componentName, UpgradeMode upgradeMode, UpgradeConfiguration upgradeConfiguration) {
        this(componentName, MAVEN_PLUGIN_AGENTS_RELATIVE_CACHE_FOLDER, upgradeMode, upgradeConfiguration);
    }

    public ComponentUpgrader(Component componentName, String componentSubFolder, UpgradeMode upgradeMode, UpgradeConfiguration upgradeConfiguration) {
        this.upgradeConfiguration = upgradeConfiguration;
        String packageVersion = ComponentUpgrader.class.getPackage().getImplementationVersion();
        this.embeddedVersion = packageVersion != null ? packageVersion : "";
        this.component = componentName;
        this.componentSubFolder = componentSubFolder;
        this.upgradeMode = upgradeMode;
        this.versionServiceProxy = new VersionServiceProxyHandler(upgradeConfiguration);
    }

    public JarFile resolveRecommendedJar() {
        if (!this.shouldTryUpgrade()) {
            LOGGER.info("{} automatic upgrade is disabled", (Object)this.component);
            return null;
        }
        try {
            return this.getComponentByVersion();
        }
        catch (Exception e) {
            throw this.createRuntimeException(e);
        }
    }

    public String resolveRecommendedJarPath() throws Exception {
        JarFile tempJar = this.resolveRecommendedJar();
        if (tempJar != null) {
            return tempJar.getName();
        }
        return "";
    }

    public String getComponentName() {
        return this.getComponent().getComponentArtifact();
    }

    protected JarFile getComponentByVersion() {
        LOGGER.info("Getting recommended version of component {} from repository {}", (Object)this.component.getComponentArtifact(), (Object)this.component.getComponentArchive());
        GetVersionResponse upgradeResponse = this.versionServiceProxy.getRecommendedVersion(this.component.getComponentArchive());
        if (!this.isValidResponse(upgradeResponse)) {
            throw this.createRuntimeException();
        }
        String recommendedVersion = upgradeResponse.getAgent().getVersion();
        if (recommendedVersion.equals(this.embeddedVersion) && !this.proceedUpgradeIfVersionAsRecommended()) {
            return null;
        }
        return this.getComponentByVersion(upgradeResponse);
    }

    protected boolean shouldTryUpgrade() {
        switch (this.upgradeMode) {
            case bootstrap: {
                boolean isDevState = this.embeddedVersion.contains(SNAPSHOT);
                return this.upgradeConfiguration.isEnableUpgrade() && !isDevState;
            }
        }
        return true;
    }

    protected boolean proceedUpgradeIfVersionAsRecommended() {
        if (this.upgradeMode == UpgradeMode.bootstrap) {
            LOGGER.info("Running '{}' has the recomended version '{}', upgrade is not needed", (Object)this.getComponentName(), (Object)this.embeddedVersion);
            return false;
        }
        return true;
    }

    protected synchronized JarFile getComponentByVersion(GetVersionResponse upgradeResponse) {
        String fileStorage = this.upgradeConfiguration.getFileStorage();
        LOGGER.debug("Using dir {} as cache for SL components", (Object)fileStorage);
        String jarsFolder = FileAndFolderUtils.join(fileStorage, SL_RELATIVE_CACHE_FOLDER, this.componentSubFolder);
        String jarsFolderAbsolutePath = new File(jarsFolder).getAbsolutePath();
        if (!FileAndFolderUtils.verifyFolderExists(jarsFolderAbsolutePath)) {
            throw this.createRuntimeException("Could not verify that cache folder exists: '" + jarsFolderAbsolutePath + "'.");
        }
        String recommendedVersion = upgradeResponse.getAgent().getVersion();
        JarFile jarFile = this.tryFindLocalFile(jarsFolderAbsolutePath, recommendedVersion);
        if (jarFile != null) {
            LOGGER.info("Component '{}', version '{}' local version exists, no download is needed", (Object)this.getComponentName(), (Object)recommendedVersion);
            return jarFile;
        }
        LOGGER.debug("Component '{}', version '{}' not exists locally, will be get from remote.", (Object)this.getComponentName(), (Object)recommendedVersion);
        jarFile = this.tryDownloadFromServer(jarsFolderAbsolutePath, upgradeResponse);
        if (jarFile != null) {
            LOGGER.info("'{}', version '{}' was downloaded successfully", (Object)this.getComponentName(), (Object)recommendedVersion);
            return jarFile;
        }
        throw this.createRuntimeException();
    }

    protected JarFile tryDownloadFromServer(String jarsFolder, GetVersionResponse upgradeResponse) {
        try {
            this.downloadRecommendedAgent(jarsFolder, upgradeResponse);
            File newAgent = this.buildPathToDownloadedAgent(jarsFolder, upgradeResponse.getAgent().getVersion());
            if (newAgent.exists()) {
                return this.createTmpJarFile(newAgent);
            }
            LOGGER.warn("Downloaded recommended agent file {} does not exist", (Object)newAgent.getName());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to download or use downloaded recommended agent version '{}' '", (Object)upgradeResponse.getAgent().getVersion());
        }
        return null;
    }

    protected JarFile tryFindLocalFile(String jarsFolder, String recommendedVersion) {
        String jarNameToFind = this.getComponentNameDash() + recommendedVersion + DOT_JAR;
        try {
            File recommendedAgent = FileAndFolderUtils.findFileInFolder(jarsFolder, jarNameToFind, DOT_JAR);
            if (recommendedAgent == null) {
                LOGGER.info("Recommended agent '{}' not found in folder '{}'", (Object)jarNameToFind, (Object)jarsFolder);
                return null;
            }
            if (!recommendedAgent.isFile()) {
                LOGGER.warn("Found local recommended agent file '{}', but it is invalid and cannot be used", (Object)recommendedAgent.getAbsolutePath());
                return null;
            }
            LOGGER.info("Found local recommended agent '{}' in folder '{}'", (Object)jarNameToFind, (Object)jarsFolder);
            return this.createTmpJarFile(recommendedAgent);
        }
        catch (Exception e) {
            LOGGER.info("Failed to use local recommended agent '{}' in folder '{}'", (Object)jarNameToFind, (Object)jarsFolder);
            return null;
        }
    }

    protected JarFile createTmpJarFile(File recommendedAgentFile) {
        return this.jarReader.copyJarToTmpJarFile(recommendedAgentFile, this.getComponentNameDash(), this.upgradeConfiguration.getFileStorage());
    }

    protected File buildPathToDownloadedAgent(String jarsFolder, String version) {
        String newAgentName = this.getComponentNameDash() + version + DOT_JAR;
        String pathToNewAgent = FileAndFolderUtils.join(jarsFolder, newAgentName);
        return new File(pathToNewAgent);
    }

    protected void downloadRecommendedAgent(String jarsFolder, GetVersionResponse upgradeResponse) {
        String zipFilePath;
        String version = upgradeResponse.getAgent().getVersion();
        String url = upgradeResponse.getAgent().getUrl();
        if (this.versionServiceProxy.downloadAgent(url, zipFilePath = this.getZipFilePath(jarsFolder))) {
            ComponentJarOrganizer organizer = new ComponentJarOrganizer();
            organizer.rearrangeJars(jarsFolder);
            ArchiveUtils.unzip(zipFilePath, jarsFolder);
            File zipFileToDelete = new File(zipFilePath);
            organizer.tryDeleteFile(zipFileToDelete, "agent zip file");
        } else {
            LOGGER.warn("Failed to download agent version '{}'", (Object)version);
        }
    }

    protected String getZipFilePath(String jarsFolder) {
        String fileName = this.component.getComponentArchive() + DOT_ZIP;
        return FileAndFolderUtils.join(jarsFolder, fileName);
    }

    protected boolean isValidResponse(GetVersionResponse upgradeResponse) {
        if (upgradeResponse == null) {
            LOGGER.warn("Got response 'null'.");
            return false;
        }
        AgentInfo agentInfo = upgradeResponse.getAgent();
        if (agentInfo == null) {
            LOGGER.warn("Got response with agent information 'null'.");
            return false;
        }
        if (!Version.isValidVersion(agentInfo.getVersion())) {
            LOGGER.warn("Got response with invalid version '" + agentInfo.getVersion() + "'.");
            return false;
        }
        if (!this.isValidAgentName(agentInfo.getName())) {
            LOGGER.warn("Got response with invalid agent name '" + agentInfo.getName() + "'.");
            return false;
        }
        return true;
    }

    protected boolean isValidAgentName(String agentName) {
        for (Component cn : Component.values()) {
            if (!cn.getComponentArchive().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    protected String nameAndDash(String name) {
        String DASH = "-";
        return name + "-";
    }

    protected String getComponentNameDash() {
        return this.nameAndDash(this.getComponentName());
    }

    private RuntimeException createRuntimeException(Exception e) {
        LOGGER.error(e.getMessage());
        return new RuntimeException(e.getMessage(), e);
    }

    private RuntimeException createRuntimeException(String errorMsg) {
        LOGGER.error(errorMsg);
        return new RuntimeException(errorMsg);
    }

    private RuntimeException createRuntimeException() {
        String errorMsg = String.format("Failed to resolve the recommended version of '%s'", this.getComponentName());
        return this.createRuntimeException(errorMsg);
    }

    @Generated
    public JarReader getJarReader() {
        return this.jarReader;
    }

    @Generated
    public void setJarReader(JarReader jarReader) {
        this.jarReader = jarReader;
    }

    @Generated
    public UpgradeConfiguration getUpgradeConfiguration() {
        return this.upgradeConfiguration;
    }

    @Generated
    public Component getComponent() {
        return this.component;
    }

    @Generated
    public String getComponentSubFolder() {
        return this.componentSubFolder;
    }

    @Generated
    public UpgradeMode getUpgradeMode() {
        return this.upgradeMode;
    }

    @Generated
    public String getEmbeddedVersion() {
        return this.embeddedVersion;
    }

    @Generated
    public void setEmbeddedVersion(String embeddedVersion) {
        this.embeddedVersion = embeddedVersion;
    }

    @Generated
    public VersionServiceProxy getVersionServiceProxy() {
        return this.versionServiceProxy;
    }

    @Generated
    public void setVersionServiceProxy(VersionServiceProxy versionServiceProxy) {
        this.versionServiceProxy = versionServiceProxy;
    }

    public static enum UpgradeMode {
        bootstrap,
        plugin;

    }
}

