/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.urlbuilder;

import io.sealights.onpremise.agents.infra.urlbuilder.UrlEscapersFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class UrlBuilder {
    public static final String SLASH = "/";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private String host = "";
    private String path = "";
    private Map<String, String> paramsMap = new HashMap<String, String>();

    public static String resloveHost(String url) {
        String host = url;
        if (!url.startsWith(HTTP) && !url.startsWith(HTTPS)) {
            host = HTTP + url;
        }
        if (host.endsWith(SLASH)) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static String encodePathSegment(String value) {
        if (StringUtils.isNotEmpty(value)) {
            return UrlEscapersFactory.urlPathSegmentEscaper().escape(value);
        }
        return null;
    }

    public static String encodeQueryParamKeyOrValue(String value) {
        if (StringUtils.isNotEmpty(value)) {
            return UrlEscapersFactory.urlFormParameterEscaper().escape(value);
        }
        return null;
    }

    public UrlBuilder withHost(String host) {
        this.host = UrlBuilder.resloveHost(host);
        return this;
    }

    public UrlBuilder withPath(String ... pathParams) {
        for (int i = 0; i < pathParams.length - 1; ++i) {
            this.path = this.path + UrlBuilder.encodePathSegment(pathParams[i]) + SLASH;
        }
        this.path = this.path + UrlBuilder.encodePathSegment(pathParams[pathParams.length - 1]);
        return this;
    }

    public UrlBuilder withQueryParam(String key, String value) {
        this.paramsMap.put(key, value);
        return this;
    }

    public UrlBuilder withNonNullQueryParam(String key, String value) {
        if (value != null) {
            this.paramsMap.put(key, value);
        }
        return this;
    }

    public String build() {
        String finalUrl = this.host + SLASH + this.path;
        if (this.paramsMap.isEmpty()) {
            return finalUrl;
        }
        return finalUrl + this.buildQueryParams();
    }

    private String buildQueryParams() {
        StringBuilder queryString = new StringBuilder();
        for (String key : this.paramsMap.keySet()) {
            this.addQueryStringValue(queryString, key, this.paramsMap.get(key));
        }
        String qs = queryString.toString();
        if ("".equals(qs)) {
            return "";
        }
        qs = "?" + qs;
        qs = qs.substring(0, qs.length() - 1);
        return qs;
    }

    private void addQueryStringValue(StringBuilder queryString, String key, String value) {
        if (StringUtils.isNotEmpty(value) || StringUtils.isNullOrEmpty(key)) {
            queryString.append(UrlBuilder.encodeQueryParamKeyOrValue(key)).append("=").append(UrlBuilder.encodeQueryParamKeyOrValue(value)).append("&");
        }
    }
}

