/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.urlbuilder;

import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;
import io.sealights.onpremise.agents.java.agent.test.infra.junit.JUnitTestBase;
import org.junit.Assert;
import org.junit.Test;

public class UrlBuilderTest
extends JUnitTestBase {
    @Test
    public void build_pathWithSpace_pathEncoded() {
        String expectedUrl = "http://host.com/path%201/path%202%20longer";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path 1", "path 2 longer").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }

    @Test
    public void build_pathWithSlashAndSpace_pathEncoded() {
        String expectedUrl = "http://host.com/path%2F1/path%202";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path/1", "path 2").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }

    @Test
    public void build_queryParamHasNoSpecialChars_shouldNotEncode() {
        String expectedUrl = "http://host.com/path1/path2?branch=master";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path1", "path2").withQueryParam("branch", "master").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }

    @Test
    public void build_pathAndQueryParamValueWithSlash_bothEncoded() {
        String expectedUrl = "http://host.com/path%2F1/path%2F2?branch=features%2FsomeFeature";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path/1", "path/2").withQueryParam("branch", "features/someFeature").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }

    @Test
    public void build_queryParamKeyAndValueWithSlash_bothEncoded() {
        String expectedUrl = "http://host.com/path1/path2?some%2Fkey=some%2Fvalue";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path1", "path2").withQueryParam("some/key", "some/value").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }

    @Test
    public void build_queryParamKeyAndValueWithSpace_bothEncoded() {
        String expectedUrl = "http://host.com/path1/path2?some+key=some+value";
        String actualUrl = new UrlBuilder().withHost("http://host.com").withPath("path1", "path2").withQueryParam("some key", "some value").build();
        Assert.assertEquals((Object)expectedUrl, (Object)actualUrl);
    }
}

