/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.io.File;
import org.slf4j.Logger;

public final class ArgumentFileReader {
    private static Logger LOG = LogFactory.getLogger(ArgumentFileReader.class);
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    public static String resolve(String argument, String argumentFile) {
        if (!StringUtils.isNullOrEmpty(argument)) {
            return argument;
        }
        return ArgumentFileReader.tryGetValueFromFile(argumentFile);
    }

    private static String tryGetValueFromFile(String argumentFile) {
        try {
            if (!StringUtils.isNullOrEmpty(argumentFile)) {
                if (new File(argumentFile).exists()) {
                    return TextFileUtils.getContent(argumentFile);
                }
                String msg = "The provided file '" + argumentFile + "' does not exists.";
                ArgumentFileReader.logError(msg);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get content of file '" + argumentFile + "'. Error: ";
            ArgumentFileReader.logError(msg);
        }
        return null;
    }

    private static void logError(String msg) {
        LOG.error(msg);
        CONSOLE_LOG.error(msg);
    }

    private ArgumentFileReader() {
    }
}

