/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileNameUtils;
import io.sealights.onpremise.agents.infra.utils.FilesCollector;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;

public class FileAndFolderUtils {
    static final ConsoleLogger logger = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(FileAndFolderUtils.class);

    public static boolean isFolderExists(String folder) {
        if (folder == null) {
            return false;
        }
        File f = new File(folder);
        return f.isDirectory();
    }

    public static boolean isFileExists(String file) {
        if (file == null) {
            return false;
        }
        File f = new File(file);
        return f.isFile();
    }

    public static File findFileInFolder(String folder, String origFileName, String extentionPattern) {
        if (StringUtils.isNullOrEmpty(folder) || StringUtils.isNullOrEmpty(origFileName) || StringUtils.isNullOrEmpty(extentionPattern)) {
            return null;
        }
        String fileName = FileNameUtils.resolveFilenameWithoutExtension(origFileName, extentionPattern);
        String fileExtension = FileNameUtils.resolveFileExtension(origFileName, extentionPattern);
        String fileWithOutExtPath = PathUtils.join(folder, fileName);
        String fileWithExtPath = PathUtils.join(folder, fileName + fileExtension);
        File fileWithExt = new File(fileWithExtPath);
        File fileWithOutExt = new File(fileWithOutExtPath);
        if (fileWithExt.exists()) {
            return fileWithExt;
        }
        if (fileWithOutExt.exists()) {
            return fileWithOutExt;
        }
        return null;
    }

    public static String join(String first, String ... pathArgs) {
        if (StringUtils.isNotEmpty(first)) {
            return Paths.get(first, pathArgs).normalize().toString();
        }
        return Paths.get("", pathArgs).toString();
    }

    public static boolean verifyFolderExists(File file) {
        if (file == null) {
            throw new NullPointerException("Argument 'file' can't be 'null'.");
        }
        String folder = file.getAbsolutePath();
        if (file.isFile()) {
            folder = file.getParentFile().getAbsolutePath();
        }
        return FileAndFolderUtils.verifyFolderExists(folder);
    }

    public static boolean verifyFolderExists(String folder) {
        if (folder == null) {
            throw new NullPointerException("Argument 'folder' can't be 'null'.");
        }
        File f = new File(folder);
        if (f.isFile()) {
            throw new IllegalArgumentException("'" + folder + "' should be path to a folder and not to a file.");
        }
        return f.isDirectory() || f.mkdirs();
    }

    public static String getFolderNameForCurrentJar() throws NullPointerException {
        String jarPath = FileAndFolderUtils.getThisJarAbsolutePath();
        return new File(jarPath).getParent();
    }

    public static String getThisJarAbsolutePath() throws NullPointerException {
        Class<FileAndFolderUtils> clazz = FileAndFolderUtils.class;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL location = codeSource.getLocation();
        return location.getPath();
    }

    public static File getOrCreateFile(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int length;
            File srcFile = new File(src);
            File destFile = new File(dest);
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean createFolder(String folder) {
        if (FileAndFolderUtils.isFolderExists(folder)) {
            return false;
        }
        File f = new File(folder);
        return f.mkdirs();
    }

    public static void writeAllTextToFile(String text, String fileName) {
        try (PrintWriter file = null;){
            File fileObj = new File(fileName);
            if (fileObj.exists()) {
                fileObj.delete();
            }
            fileObj.createNewFile();
            file = new PrintWriter(fileObj);
            file.println(text);
        }
    }

    public static void writeAllTextToZipFile(String text, String filename) throws IOException {
        FileOutputStream dest = new FileOutputStream(filename);
        GZIPOutputStream gzip = new GZIPOutputStream(dest);
        gzip.write(text.getBytes());
        gzip.close();
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static List<String> getAndFilterNonexistentFiles(List<String> providedReportsFolders) {
        return FileAndFolderUtils.getAndFilterNonexistentFiles(providedReportsFolders, false);
    }

    public static List<String> getAndFilterNonexistentFiles(List<String> providedReportsFolders, boolean filterNonexistent) {
        ArrayList<String> filteredFiles = new ArrayList<String>();
        Iterator<String> i = providedReportsFolders.iterator();
        while (i.hasNext()) {
            String filePath = i.next();
            if (filePath != null && new File(filePath).exists()) continue;
            filteredFiles.add(filePath);
            if (!filterNonexistent) continue;
            i.remove();
        }
        return filteredFiles;
    }

    public static List<String> getExistingFilesNames(File[] files) {
        ArrayList<String> filesNames = new ArrayList<String>();
        for (File f : files) {
            if (f == null || !f.exists()) continue;
            filesNames.add(f.getAbsolutePath());
        }
        return filesNames;
    }

    public static String createBackupFile(String original, String extension) throws IOException {
        Path originalPath = Paths.get(original, new String[0]);
        Path backupPath = Paths.get(original + "." + extension, new String[0]);
        Path path = Files.copy(originalPath, backupPath, StandardCopyOption.COPY_ATTRIBUTES);
        return path.toString();
    }

    public static boolean clearDirectory(File directory) throws IOException {
        if (directory == null || !directory.isDirectory() || directory.listFiles() == null) {
            return false;
        }
        for (File fileOrDirectory : directory.listFiles()) {
            if (fileOrDirectory.isDirectory()) {
                if (!FileAndFolderUtils.clearDirectory(fileOrDirectory)) {
                    return false;
                }
                if (fileOrDirectory.delete()) continue;
                return false;
            }
            if (!fileOrDirectory.isFile() || fileOrDirectory.delete()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileAndFolderUtils.copyFolder(srcFile, destFile);
            }
        } else {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                int length;
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static File discoverFirstRealFolderOrFile(File file) {
        File tempFile = file;
        while (!tempFile.exists() && (tempFile = tempFile.getParentFile()) != null) {
        }
        return tempFile;
    }

    public static void verifyParentsExist(File overridePathFile) {
        File parent = overridePathFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static String getContainingFolder() {
        try {
            File jarFile = new File(FileAndFolderUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            return URLDecoder.decode(jarFile.getParent(), StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            String message = String.format("Error while trying to get jar containing folder. %s", e);
            logger.error(message);
            return null;
        }
    }

    public static List<File> collectFolderFilesByExtention(String folderName, String extension) {
        return new FilesCollector().collectByExactMatchEnding(folderName, extension, false);
    }

    public static List<File> collectFilesByExtentionRecursively(String folderName, String extension) {
        return new FilesCollector().collectByIgnoreCaseMatchEnding(folderName, extension, true);
    }

    public static List<File> collectFilesByExtensionRecursivelyFilesFirst(String folderName, String extension) {
        return new FilesCollector(FilesCollector.FILES_BEFORE_DIRS_COMPARATOR).collectByIgnoreCaseMatchEnding(folderName, extension, true);
    }

    public static String resolveAbsolutePath(String inputPath) {
        if (StringUtils.isNullOrEmpty(inputPath)) {
            return inputPath;
        }
        try {
            Path inputPathRoot = Paths.get(inputPath, new String[0]).getRoot();
            if (inputPathRoot != null) {
                return inputPath;
            }
            return FileSystems.getDefault().getPath(inputPath, new String[0]).normalize().toAbsolutePath().toString();
        }
        catch (Exception e) {
            LOG.error("Failed to resolve the absolute path for '{}'", (Object)inputPath, (Object)e);
            return null;
        }
    }
}

