/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;

public final class FileNameUtils {
    private static final String FILE_WITH_EXTENTION_FMT = "%s%s";

    public static String resolveFilenameWithoutExtension(String file, String extentionPattern) {
        String name = file;
        if (StringUtils.isNullOrEmpty(file)) {
            throw new RuntimeException("Cannot resolve file name. file cannot be null");
        }
        int lastDot = file.indexOf(extentionPattern);
        if (lastDot > 0) {
            name = file.substring(0, lastDot);
        }
        return name;
    }

    public static String resolveFileExtension(String file, String extentionPattern) {
        String extension = file;
        if (StringUtils.isNullOrEmpty(file)) {
            throw new RuntimeException("Cannot resolve file extension. file cannot be null");
        }
        int lastDot = file.indexOf(extentionPattern);
        if (lastDot > 0) {
            extension = file.substring(lastDot);
        }
        return extension;
    }

    public static String normalizeFileName(String fileName, String extentionPattern) {
        String filenameWithoutExt = FileNameUtils.resolveFilenameWithoutExtension(fileName, extentionPattern);
        return String.format(FILE_WITH_EXTENTION_FMT, filenameWithoutExt, ".txt");
    }

    public static boolean matchRequestedName(String fullFilePath, String fileName, String extentionPattern) {
        String fileExtention = FileNameUtils.detectFileExtention(fullFilePath);
        if (StringUtils.isNotEmpty(fileExtention) && !fileExtention.equals(extentionPattern)) {
            return false;
        }
        String matchingName = FileNameUtils.resolveFilenameWithoutExtension(fileName, fileExtention).toLowerCase();
        String lowerCaseFileName = fullFilePath.toLowerCase();
        return lowerCaseFileName.endsWith(matchingName) || lowerCaseFileName.endsWith(String.format(FILE_WITH_EXTENTION_FMT, matchingName, extentionPattern));
    }

    protected static String detectFileExtention(String fullFilePath) {
        String fileExtention = "";
        int lastDot = fullFilePath.lastIndexOf(46);
        if (lastDot > 0) {
            fileExtention = fullFilePath.substring(lastDot).toLowerCase();
        }
        return fileExtention;
    }

    @Generated
    private FileNameUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

