/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import io.sealights.onpremise.agents.infra.constants.Constants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String TAB = "\t";
    public static final String EOL = "\n";
    public static final String END_R = "\r";
    public static final String SPACE = " ";
    public static final String NEW_LINE = "\n";
    public static final String COMMA_SEPARATOR = ",";
    private static final String QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String REPLACE_END_N_PATTERN = "[\n]";
    private static final String REPLACE_END_N_R_PATTERN = "[\n\r]";

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isNullOrEmpty(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || EMPTY_STRING.equals(str);
    }

    public static String join(List<String> strings, char delimiter) {
        String strDelimiter = String.valueOf(delimiter);
        return StringUtils.join(strings, strDelimiter);
    }

    public static String join(List<String> strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        StringBuilder retString = new StringBuilder(Constants.BYTES_IN_KB);
        if (!strings.isEmpty()) {
            for (int i = 0; i < strings.size() - 1; ++i) {
                retString.append(strings.get(i));
                retString.append(delimiter);
            }
            retString.append(strings.get(strings.size() - 1));
        }
        return retString.toString();
    }

    public static String capitalizeFirstCharacter(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        char first = Character.toUpperCase(str.charAt(0));
        str = first + str.substring(1);
        return str;
    }

    public static String removeWrappingQuotes(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        return str.replaceAll("^\"|\"$", EMPTY_STRING);
    }

    public static String removeWrappingSingleQuotes(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        return str.replaceAll("^'|'$", EMPTY_STRING);
    }

    public static String inQuotes(String value) {
        if (value != null) {
            return QUOTE + value + QUOTE;
        }
        return value;
    }

    public static String inSingleQuotes(String value) {
        if (value != null) {
            return SINGLE_QUOTE + value + SINGLE_QUOTE;
        }
        return value;
    }

    public static List<String> splitByComma(String s) {
        return StringUtils.split(s, COMMA_SEPARATOR);
    }

    public static List<String> split(String s, String separator) {
        if (StringUtils.isNullOrEmpty(s)) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.split(separator));
    }

    public static String stripEndLinesAndTabs(String original) {
        if (original != null) {
            return original.replaceAll(REPLACE_END_N_R_PATTERN, EMPTY_STRING).replaceAll(TAB, SPACE);
        }
        return null;
    }

    public static String[] splitToLines(String original) {
        if (original != null) {
            String temp = original.replace(END_R, EMPTY_STRING);
            String[] lines = temp.split(REPLACE_END_N_PATTERN);
            if (lines.length > 1) {
                lines[lines.length - 1].replace("\n", EMPTY_STRING);
            }
            return lines;
        }
        return null;
    }

    public static String getLastNChars(String toCut, int nLast) {
        if (StringUtils.isNullOrEmpty(toCut) || nLast < 1) {
            return EMPTY_STRING;
        }
        if (toCut.length() <= nLast) {
            return toCut;
        }
        return toCut.substring(toCut.length() - nLast);
    }

    public static String getFirstNChars(String toCut, int nFirst) {
        if (StringUtils.isNullOrEmpty(toCut) || nFirst < 1) {
            return EMPTY_STRING;
        }
        if (toCut.length() <= nFirst) {
            return toCut;
        }
        return toCut.substring(0, nFirst);
    }

    @Generated
    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

