/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public final class TextFileUtils {
    public static String getCommentPrefix(String filePath) {
        if (filePath.endsWith(".bat")) {
            return "::";
        }
        if (filePath.endsWith(".java")) {
            return "//";
        }
        return "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String filePath) throws IOException {
        String newLine = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filePath));
            String str = in.readLine();
            while (str != null) {
                sb.append(str);
                str = in.readLine();
                if (str == null) continue;
                sb.append(newLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    public static void writeToFile(String path, String content) throws IOException {
        TextFileUtils.writeToFile(path, content, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String path, String content, boolean overrideContent) throws IOException {
        if (path == null) {
            throw new NullPointerException("'path' cannot be null.");
        }
        if (content == null) {
            throw new NullPointerException("Content cannot be null.");
        }
        BufferedWriter bw = null;
        FileWriter fw = null;
        try {
            if (overrideContent) {
                fw = new FileWriter(path);
                bw = new BufferedWriter(fw);
                bw.write(content);
            } else {
                boolean append = true;
                fw = new FileWriter(path, append);
                bw = new BufferedWriter(fw);
                bw.append(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private TextFileUtils() {
    }
}

