/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.instrumentation;

import io.sealights.onpremise.agents.infra.utils.instrumentation.BytecodeMethodAccessHelper;
import java.util.Arrays;
import org.objectweb.asm.Type;

public class MethodNamingUtils {
    public static String getElementId(int access, String name, String desc) {
        StringBuilder methodNameSb = new StringBuilder();
        String modifiers = MethodNamingUtils.accessToString(access);
        methodNameSb.append(modifiers);
        methodNameSb.append(Type.getReturnType((String)desc));
        methodNameSb.append(" " + name);
        methodNameSb.append(Arrays.toString(Type.getArgumentTypes((String)desc)));
        return methodNameSb.toString();
    }

    public static String accessToString(int access) {
        StringBuilder sb = new StringBuilder();
        if (BytecodeMethodAccessHelper.isPrivate(access)) {
            sb.append("private ");
        }
        if (BytecodeMethodAccessHelper.isProtected(access)) {
            sb.append("protected ");
        }
        if (BytecodeMethodAccessHelper.isPublic(access)) {
            sb.append("public ");
        }
        if (BytecodeMethodAccessHelper.isStatic(access)) {
            sb.append("static ");
        }
        if (BytecodeMethodAccessHelper.isSynchronized(access)) {
            sb.append("synchronized ");
        }
        if (BytecodeMethodAccessHelper.isFinal(access)) {
            sb.append("final ");
        }
        if (BytecodeMethodAccessHelper.isNative(access)) {
            sb.append("native ");
        }
        if (BytecodeMethodAccessHelper.isBridge(access)) {
            sb.append("bridge ");
        }
        if (BytecodeMethodAccessHelper.isVarargs(access)) {
            sb.append("varargs ");
        }
        if (BytecodeMethodAccessHelper.isStrict(access)) {
            sb.append("strictfp ");
        }
        if (BytecodeMethodAccessHelper.isAbstract(access)) {
            sb.append("abstract ");
        }
        return sb.toString();
    }

    public static String createMethodUniqueId(int access, String methodId, String descriptor, String exceptions) {
        return Integer.toString(access) + " | " + methodId + " | " + descriptor + " | " + exceptions;
    }
}

