/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.jvm;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;

public class JvmUtils {
    public static final String JAVA = "java";
    public static final String DOT_JAR = ".jar";
    private static final Logger LOGGER = LogFactory.getLogger(JvmUtils.class);
    private static final char COMMANDLINE_SEPARATOR = ' ';
    private static final int CHAR_NOT_FOUND_INDEX = -1;

    public File getApplicationJarFile() {
        String runCommand = JvmUtils.getRunCommand();
        if (runCommand == null) {
            return null;
        }
        File jarArgumentValue = JvmUtils.getJarArgumentValue(runCommand);
        if (jarArgumentValue != null) {
            return jarArgumentValue;
        }
        return JvmUtils.jarFileFromRunMainClassCommand(runCommand);
    }

    public static boolean runNewJvm(List<String> cliCommand) {
        try {
            ProcessBuilder pb = new ProcessBuilder(cliCommand);
            pb.inheritIO();
            Process p = pb.start();
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            LOGGER.error("Execution failed with error: ", (Throwable)e);
            return false;
        }
    }

    public static String getRunCommand() {
        return System.getProperty("sun.java.command");
    }

    public static String resolveJavaPath() {
        String javaPath = System.getProperty("java.home");
        if (StringUtils.isNullOrEmpty(javaPath)) {
            javaPath = System.getProperty("sl.java.home");
        }
        javaPath = StringUtils.isNullOrEmpty(javaPath) ? JAVA : PathUtils.join(javaPath, "bin", JAVA);
        LOGGER.info("current java path:'{}'", (Object)javaPath);
        return javaPath;
    }

    private static File getJarArgumentValue(String runCommand) {
        int dotJarIndex = runCommand.indexOf(DOT_JAR);
        if (dotJarIndex == -1) {
            return null;
        }
        String jarLocationCandidate = runCommand.substring(0, dotJarIndex + DOT_JAR.length());
        File jarFile = new File(jarLocationCandidate);
        if (jarFile.exists()) {
            LOGGER.info("Detected jar location:'{}' (the '-jar' argument of 'java' run command) ", (Object)jarLocationCandidate);
            return jarFile;
        }
        return null;
    }

    private static File jarFileFromRunMainClassCommand(String runCommand) {
        int clSeparatorIdx = runCommand.indexOf(32);
        int endOfClassNameIdx = clSeparatorIdx == -1 ? runCommand.length() : clSeparatorIdx;
        String className = runCommand.substring(0, endOfClassNameIdx);
        try {
            Class<?> runClass = Class.forName(className);
            URI jarLocation = runClass.getProtectionDomain().getCodeSource().getLocation().toURI();
            LOGGER.info("Detected jar location:'{}' (the jar containing the main class '{}')", (Object)jarLocation, (Object)className);
            return new File(jarLocation);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't get path of the containing jar based on the assumed main class: '{}'", (Object)className, (Object)e);
            return null;
        }
    }
}

