/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.utils.threads;

import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public abstract class TimeoutTimer
implements TaskScheduler.Task {
    private TaskScheduler scheduler = new TaskScheduler(this.getName());
    private long expirationMillis;

    public TimeoutTimer(int expirationSecs) {
        this(expirationSecs, TimeUnit.SECONDS);
    }

    public TimeoutTimer(int expiration, TimeUnit units) {
        this.expirationMillis = TimeUnit.MILLISECONDS.convert(expiration, units);
    }

    public void start() {
        this.scheduler.assignTaskForOneExecution(this, this.getExpirationMillis());
    }

    public void stop() {
        this.scheduler.stop();
    }

    public void cancel() {
        this.scheduler.cancelTask();
    }

    @Generated
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public long getExpirationMillis() {
        return this.expirationMillis;
    }

    @Generated
    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Generated
    public void setExpirationMillis(long expirationMillis) {
        this.expirationMillis = expirationMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeoutTimer)) {
            return false;
        }
        TimeoutTimer other = (TimeoutTimer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpirationMillis() != other.getExpirationMillis()) {
            return false;
        }
        TaskScheduler this$scheduler = this.getScheduler();
        TaskScheduler other$scheduler = other.getScheduler();
        return !(this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeoutTimer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expirationMillis = this.getExpirationMillis();
        result = result * 59 + (int)($expirationMillis >>> 32 ^ $expirationMillis);
        TaskScheduler $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeoutTimer(scheduler=" + this.getScheduler() + ", expirationMillis=" + this.getExpirationMillis() + ")";
    }
}

