/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin;

import io.sealights.onpremise.agents.plugin.MavenEventsListener;
import java.util.Map;

public class BuildFailureFormatter {
    public static final String SPECIAL_CHAR = "\u001b[";
    public static final String EOF_LINE = "\n";
    private static final String EOF_SPECIAL_CHAR = "m";

    public static String format(String rawString) {
        String tmp;
        String converted = rawString;
        while ((tmp = BuildFailureFormatter.extractNextSpecialChar(converted)) != null) {
            converted = tmp;
        }
        return converted.replace(EOF_LINE, "");
    }

    public static String collectFailures(MavenEventsListener.FailedProjectInfo buildFailure, Map<String, MavenEventsListener.FailedProjectInfo> projectsFailures) {
        if (projectsFailures.isEmpty()) {
            return buildFailure.reason;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(buildFailure.reason).append(": {");
        int ctr = 0;
        int last = projectsFailures.size() - 1;
        for (String pname : projectsFailures.keySet()) {
            builder.append(String.format("\nproject:'%s', failure: '%s'", pname, projectsFailures.get((Object)pname).reason));
            if (ctr < last) {
                builder.append("; ");
            }
            ++ctr;
        }
        builder.append("\n}");
        return builder.toString();
    }

    private static String extractNextSpecialChar(String rawString) {
        int startPos = rawString.indexOf(SPECIAL_CHAR);
        if (startPos == -1) {
            return null;
        }
        int endPos = rawString.substring(startPos).indexOf(EOF_SPECIAL_CHAR);
        if (endPos == -1) {
            return null;
        }
        return rawString.substring(0, startPos) + rawString.substring(startPos + endPos + 1);
    }
}

