/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin;

import io.sealights.onpremise.agents.plugin.BuildFailureFormatter;
import io.sealights.plugins.engine.lifecycle.BuildEndInfo;
import io.sealights.plugins.engine.lifecycle.BuildEndListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import lombok.Generated;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public enum MavenEventsListener implements InvocationHandler
{
    INSTANCE;

    public static final String BUILD_SUBPROJECTS_FAILED = "Build failed due to sub-projects failure";
    public static final String DEFAULT_PROJECT_NAME = "project name cannot be resolved";
    private static final String METHOD_NAME_PROJECT_FAILED = "projectFailed";
    private static final String METHOD_NAME_SESSION_ENDED = "sessionEnded";
    private static final String METHOD_MOJO_FAILED = "mojoFailed";
    private static final String METHOD_FORK_FAILED = "forkFailed";
    private MavenSession session;
    private ExecutionListener mavenExecutionListener;
    private BuildEndListener buildEndListener;
    private volatile boolean initialized = false;
    private HashMap<String, FailedProjectInfo> projectsFailures = new HashMap();

    public synchronized boolean initialize(MavenSession session, BuildEndListener buildEndListener) {
        if (this.initialized) {
            return false;
        }
        if (buildEndListener != null) {
            this.session = session;
            this.buildEndListener = buildEndListener;
            this.doInitialization();
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object invoke(Object target, Method method, Object[] args) throws Throwable {
        ExecutionEvent event = args.length > 0 ? (ExecutionEvent)args[0] : null;
        this.handleIfProjectFailure(method, event);
        this.handleIfEndOfBuild(method, event);
        this.informOnError(method, event);
        return method.invoke((Object)this.mavenExecutionListener, args);
    }

    public FailedProjectInfo extractBuildFailureReason(MavenProject currentProject, boolean addToProjectsFailures) {
        FailedProjectInfo failureInfo = null;
        if (currentProject == null) {
            MavenProject rootProject = this.session.getTopLevelProject();
            failureInfo = new FailedProjectInfo(rootProject != null ? rootProject.getName() : DEFAULT_PROJECT_NAME, BUILD_SUBPROJECTS_FAILED);
        } else {
            BuildSummary buildSummary = this.session.getResult().getBuildSummary(currentProject);
            if (buildSummary instanceof BuildSuccess && this.projectsFailures.isEmpty()) {
                return null;
            }
            if (buildSummary instanceof BuildFailure) {
                BuildFailure failure = (BuildFailure)buildSummary;
                failureInfo = new FailedProjectInfo(currentProject.getName());
                failureInfo.reason = BuildFailureFormatter.format(failure.getCause().toString());
            } else {
                failureInfo = new FailedProjectInfo(currentProject.getName(), BUILD_SUBPROJECTS_FAILED);
            }
        }
        if (!this.projectsFailures.containsKey(failureInfo.projectName)) {
            this.projectsFailures.put(failureInfo.projectName, failureInfo);
        }
        return failureInfo;
    }

    private void doInitialization() {
        this.mavenExecutionListener = this.session.getRequest().getExecutionListener();
        Object instance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ExecutionListener.class}, (InvocationHandler)this);
        this.session.getRequest().setExecutionListener((ExecutionListener)instance);
        this.buildEndListener.getPluginLogger().info("Initialized, session:'{}', buildEndListener:{}", (Object)this.session, (Object)this.buildEndListener);
        this.initialized = true;
    }

    private void handleIfEndOfBuild(Method method, ExecutionEvent event) {
        if (!method.getName().equals(METHOD_NAME_SESSION_ENDED)) {
            return;
        }
        MavenProject project = this.session.getResult().getProject();
        this.logMethodInfo(method, project, null);
        BuildSummary buildSummary = this.session.getResult().getBuildSummary(project);
        BuildEndInfo buildInfo = new BuildEndInfo();
        buildInfo.setBuildDurationMSec(buildSummary != null ? buildSummary.getTime() : 0L);
        FailedProjectInfo buildFailure = this.extractBuildFailureReason(this.session.getResult().getProject(), false);
        if (buildFailure == null) {
            buildInfo.setSuccess(true);
        } else {
            buildInfo.setSuccess(false);
            if (this.projectsFailures.isEmpty()) {
                buildInfo.setFailureReason(buildFailure.reason);
            } else {
                buildInfo.setSuccess(false);
                buildInfo.setFailureReason(BuildFailureFormatter.collectFailures(buildFailure, this.projectsFailures));
            }
        }
        this.buildEndListener.notifyBuildEndInfo(buildInfo);
    }

    private void handleIfProjectFailure(Method method, ExecutionEvent event) {
        if (!method.getName().equals(METHOD_NAME_PROJECT_FAILED)) {
            return;
        }
        MavenProject currentPoject = this.session.getCurrentProject();
        this.logMethodInfo(method, currentPoject, null);
        this.extractBuildFailureReason(currentPoject, true);
    }

    private void informOnError(Method method, ExecutionEvent event) {
        if (method.getName().equals(METHOD_MOJO_FAILED) || method.getName().equals(METHOD_FORK_FAILED)) {
            this.logMethodInfo(method, this.session.getCurrentProject(), event);
        }
    }

    private void logMethodInfo(Method method, MavenProject project, ExecutionEvent event) {
        if (event != null && event.getException() != null) {
            this.buildEndListener.getPluginLogger().info("Handling '{}', exception:'{}', project:'{}', session:{}", new Object[]{method.getName(), event.getException().getMessage().replaceAll("\n", ""), project != null ? project.getName() : project, this.session});
        } else {
            this.buildEndListener.getPluginLogger().info("Handling '{}', project:'{}', session:{}", new Object[]{method.getName(), project != null ? project.getName() : project, this.session});
        }
    }

    @Generated
    public void setSession(MavenSession session) {
        this.session = session;
    }

    static class FailedProjectInfo {
        private static final String UNKNOWN_FAILURE = "Undefined failure reason";
        String projectName;
        String reason = "Undefined failure reason";

        FailedProjectInfo(String projectName) {
            this.projectName = projectName;
        }

        FailedProjectInfo(String projectName, String reason) {
            this(projectName);
            this.reason = reason;
        }
    }
}

