/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin;

import io.sealights.onpremise.agents.infra.logging.DefaultLogManager;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.plugin.MavenEventsListener;
import io.sealights.onpremise.agents.plugin.MavenSessionExtension;
import io.sealights.onpremise.agents.plugin.logging.MavenLogWrapper;
import io.sealights.onpremise.agents.plugin.surefire.PluginsHandler;
import io.sealights.plugins.engine.api.DependencyInfo;
import io.sealights.plugins.engine.api.ExecutionStage;
import io.sealights.plugins.engine.api.PluginEngine;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginParameters;
import io.sealights.plugins.engine.api.PluginType;
import io.sealights.plugins.engine.api.ProjectDescriptor;
import io.sealights.plugins.engine.lifecycle.BuildEndInfo;
import io.sealights.plugins.engine.lifecycle.BuildEndListener;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import io.sealights.plugins.engine.procsexecutor.PluginEngineHandler;
import io.sealights.plugins.engine.utils.FilesStorageGoalHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

public abstract class SeaLightsMojo
extends AbstractMojo
implements PluginGoal,
BuildEndListener {
    public static final String SEALIGHTS_MAVEN_PLUGIN = "sealights-mvn-plugin";
    public static final String POM_PACKAGING_VALUE = "pom";
    private PluginEngine pluginEngine = new PluginEngineHandler();
    private Logger logger;
    private PluginsHandler pluginsHandler;
    private MavenProject project;
    private String token;
    private String tokenFile;
    private String customerid;
    private String server;
    private String proxy;
    private String workspacepath;
    private boolean createBuildSessionId;
    private String buildSessionId;
    private String buildSessionIdFile;
    private String appName;
    private boolean moduleNameArtifactId;
    private String environment;
    private String branch;
    private String build;
    private String packagesincluded;
    private String packagesexcluded;
    private boolean createPRBuildSessionId;
    private String repositoryUrl;
    private int pullRequestNumber;
    private String latestCommit;
    private String targetBranch;
    private String filesincluded;
    private String filesexcluded;
    private boolean recursive;
    private boolean logEnabled;
    private boolean logPluginMinimal;
    private String logLevel;
    private boolean logToFile;
    private boolean logToConsole;
    private String logFolder;
    private String javaPath;
    private String filesStorage;
    private Map<String, Object> metadata;
    private Map<String, ?> sealightsJvmParams;
    private String overrideMetaJsonPath;
    private boolean includeResources;
    private boolean includeTokenResource;
    private String buildScannerJar;
    private String testListenerJar;
    private String testStage;
    private String labId;
    private boolean createExecutionId;
    private boolean runTestOnly;
    private boolean runScanOnly;
    private boolean runFunctionalTests;
    private MavenSession session;
    private String sealightsPluginVersion;
    private PluginParameters params;

    @Override
    public PluginType getPluginType() {
        return PluginType.maven;
    }

    @Override
    public String getBuildToolVersion() {
        return this.project.getProjectBuildingRequest().getSystemProperties().getProperty("maven.version");
    }

    public void execute() {
        boolean goalExecutedOk = false;
        try {
            if (this.getExecData().getExecStage() != ExecutionStage.initFailed) {
                goalExecutedOk = this.executePluginGoal();
            }
        }
        catch (Exception e) {
            this.logger.info("Unexpected exception, failed execute {}; proceed build without Sealights", (Object)this.getInternalName());
        }
        finally {
            if (!goalExecutedOk) {
                this.logger.info("{} due to '{}' goal failure", (Object)"skip SEALIGHTS integration", (Object)this.getMojoName());
            }
        }
    }

    @Override
    public String getName() {
        return this.getMojoName();
    }

    public String getInternalName() {
        return String.format("%s - project:%s, mojo:%s, session:%s", this.getModuleName(), this.getMojoName(), this.toStringInstanceShort(this), this.toStringInstanceShort(this.session));
    }

    protected String toStringInstanceShort(Object instance) {
        if (instance != null) {
            String instStr = instance.toString();
            int lastDotIndex = instStr.lastIndexOf(".");
            if (lastDotIndex != -1 && lastDotIndex < instStr.length() - 1) {
                String subst = instStr.substring(lastDotIndex + 1);
                return subst;
            }
            return instStr;
        }
        return null;
    }

    @Override
    public void initGoalInternals() {
        this.pluginsHandler.detectConfigurations();
        this.normalizeInput();
        MavenEventsListener.INSTANCE.initialize(this.session, this);
    }

    @Override
    public boolean postExecute() {
        return true;
    }

    @Override
    public void onFailure() {
        this.pluginsHandler.updateProperties(PluginsHandler.SEALIGHTS_DISABLED, this.getExecData().getToken(), false);
    }

    @Override
    public String getModuleName() {
        if (this.moduleNameArtifactId) {
            return this.project.getArtifactId();
        }
        return this.project.getName();
    }

    @Override
    public ProjectDescriptor getProjectDescriptor() {
        List<DependencyInfo> pluginsDeps = this.buildProjectPluginsData();
        List<DependencyInfo> projectDeps = this.buildProjectDependencyData();
        return new ProjectDescriptor(SEALIGHTS_MAVEN_PLUGIN, this.sealightsPluginVersion, this.getModuleName(), this.project.getVersion(), this.project.getProperties(), this.project.getBuild().getSourceDirectory(), this.project.getBasedir() != null ? this.project.getBasedir().getAbsolutePath() : null, this.project.getBuild().getOutputDirectory(), projectDeps, pluginsDeps);
    }

    @Override
    public void notifyBuildEndInfo(BuildEndInfo buildEndInfo) {
        this.pluginEngine.notifyBuildEnd(this, buildEndInfo);
    }

    @Override
    public Logger getPluginLogger() {
        return this.getLogger();
    }

    public String getProjectProperty(String propKey) {
        if (this.project != null) {
            return this.project.getProperties().getProperty(propKey);
        }
        return null;
    }

    public void setProject(MavenProject project) {
        this.setupLogging();
        this.pluginsHandler = MavenSessionExtension.INSTANCE.getOrCreateTestPluginsHandler(project, this.logger);
        this.project = project;
    }

    public void setProjectProperty(String propKey, String propValue) {
        if (this.project != null) {
            this.project.getProperties().setProperty(propKey, propValue);
        }
    }

    public void normalizeInput() {
        this.normalizeLogSettings();
    }

    protected PluginExecData getExecData() {
        return BuildLifeCycle.getExecData();
    }

    protected Properties getProjectProperties() {
        return this.project.getProperties();
    }

    protected List<DependencyInfo> buildProjectDependencyData() {
        ArrayList<DependencyInfo> dependenciesData = new ArrayList<DependencyInfo>();
        for (Dependency d : this.project.getDependencies()) {
            dependenciesData.add(new DependencyInfo(d.getGroupId(), d.getArtifactId(), d.getVersion()));
        }
        return dependenciesData;
    }

    protected List<DependencyInfo> buildProjectPluginsData() {
        ArrayList<DependencyInfo> pluginsData = new ArrayList<DependencyInfo>();
        for (Plugin p : this.project.getBuildPlugins()) {
            pluginsData.add(new DependencyInfo(p.getGroupId(), p.getArtifactId(), p.getVersion()));
            if (!p.getArtifactId().contains("sealights")) continue;
            this.sealightsPluginVersion = p.getVersion();
        }
        return pluginsData;
    }

    @Override
    public synchronized PluginParameters getParams() {
        if (this.params == null) {
            this.params = new PluginParameters();
            this.initParams();
        }
        return this.params;
    }

    protected void initParams() {
        this.params.getGeneralParams().setToken(this.token);
        this.params.getGeneralParams().setTokenFile(this.tokenFile);
        this.params.getGeneralParams().setCustomerId(this.customerid);
        this.params.getGeneralParams().setServer(this.server);
        this.params.getGeneralParams().setProxy(this.proxy);
        this.params.getGeneralParams().setWorkspacepath(this.workspacepath);
        this.params.getGeneralParams().setCreateBuildSessionId(this.createBuildSessionId);
        this.params.getGeneralParams().setBuildSessionId(this.buildSessionId);
        this.params.getGeneralParams().setBuildSessionIdFile(this.buildSessionIdFile);
        this.params.getGeneralParams().setAppName(this.appName);
        this.params.getGeneralParams().setEnvironment(this.environment);
        this.params.getGeneralParams().setBranch(this.branch);
        this.params.getGeneralParams().setBuild(this.build);
        this.params.getGeneralParams().setPackagesIncluded(this.packagesincluded);
        this.params.getGeneralParams().setPackagesExcluded(this.packagesexcluded);
        this.params.getGeneralParams().setCreatePRBuildSessionId(this.createPRBuildSessionId);
        this.params.getGeneralParams().setRepositoryUrl(this.repositoryUrl);
        this.params.getGeneralParams().setPullRequestNumber(this.pullRequestNumber);
        this.params.getGeneralParams().setLatestCommit(this.latestCommit);
        this.params.getGeneralParams().setTargetBranch(this.targetBranch);
        this.params.getGeneralParams().setFilesincluded(this.filesincluded);
        this.params.getGeneralParams().setFilesexcluded(this.filesexcluded);
        this.params.getGeneralParams().setRecursive(this.recursive);
        this.params.getGeneralParams().setLogEnabled(this.logEnabled);
        this.params.getGeneralParams().setLogPluginMinimal(this.logPluginMinimal);
        this.params.getGeneralParams().setLogLevel(this.logLevel);
        this.params.getGeneralParams().setLogToFile(this.logToFile);
        this.params.getGeneralParams().setLogToConsole(this.logToConsole);
        this.params.getGeneralParams().setLogFolder(this.logFolder);
        this.params.getGeneralParams().setJavaPath(this.javaPath);
        this.params.getGeneralParams().setFilesStorage(FilesStorageGoalHelper.normalizeFilesStorage(this, this.filesStorage));
        this.params.getGeneralParams().setMetadata(this.metadata);
        this.params.getGeneralParams().setSealightsJvmParams(this.sealightsJvmParams);
        this.params.getGeneralParams().setOverrideMetaJsonPath(this.overrideMetaJsonPath);
        this.params.getGeneralParams().setIncludeResources(this.includeResources);
        this.params.getGeneralParams().setIncludeTokenResource(this.includeTokenResource);
        this.params.getGeneralParams().setBuildScannerJar(this.buildScannerJar);
        this.params.getGeneralParams().setTestListenerJar(this.testListenerJar);
        this.params.getGeneralParams().setTestStage(this.testStage);
        this.params.getGeneralParams().setLabId(this.labId);
        this.params.getGeneralParams().setCreateExecutionId(this.createExecutionId);
        this.params.getGeneralParams().setRunScanOnly(this.runScanOnly);
        this.params.getGeneralParams().setRunTestOnly(this.runTestOnly);
        this.params.getGeneralParams().setRunFunctionalTests(this.runFunctionalTests);
    }

    private void normalizeLogSettings() {
        if (Level.OFF.equals((Object)Level.get(this.logLevel))) {
            this.logger.info("missing 'logEnabled' parameter was set to '{}' due to logLevel '{}'", (Object)false, (Object)this.logLevel);
            this.logEnabled = false;
        }
        if (!this.logEnabled) {
            return;
        }
        if (this.logToFile) {
            return;
        }
        if (!this.logToConsole) {
            this.logToConsole = true;
            this.logger.info("missing 'logToConsole' parameter was set to '{}'", (Object)true);
        }
    }

    public void setupLogging() {
        Level level = this.logPluginMinimal ? Level.OFF : Level.INFO;
        LogFactory.setConsoleLogLevel(level);
        if (this.logger != null) {
            return;
        }
        this.logger = new MavenLogWrapper(this.getLog(), !this.logPluginMinimal);
        LogFactory.bindLogManager(new DefaultLogManager(){

            @Override
            public Logger getFrameworkLogger(Class<?> clazz) {
                return SeaLightsMojo.this.logger;
            }

            @Override
            public Logger getFrameworkLogger(String name) {
                return SeaLightsMojo.this.logger;
            }
        });
    }

    @Override
    public String locateFile(String agentPathInput) {
        if (agentPathInput == null) {
            return null;
        }
        Path path = Paths.get(agentPathInput, new String[0]);
        if (path.isAbsolute()) {
            return agentPathInput;
        }
        for (MavenProject currentProject = this.getProject(); currentProject != null; currentProject = currentProject.getParent()) {
            String baseDirPath = currentProject.getBasedir().getPath();
            String filePathRelativizedToBaseDir = Paths.get(baseDirPath, agentPathInput).normalize().toString();
            if (!new File(filePathRelativizedToBaseDir).exists()) continue;
            this.getLogger().info("agent jar found in parent dir " + filePathRelativizedToBaseDir);
            return filePathRelativizedToBaseDir;
        }
        this.getLogger().warn("failed to resolve agent path for the input relative path " + agentPathInput);
        return null;
    }

    protected abstract boolean executePluginGoal();

    protected abstract String getMojoName();

    @Generated
    public PluginEngine getPluginEngine() {
        return this.pluginEngine;
    }

    @Override
    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public PluginsHandler getPluginsHandler() {
        return this.pluginsHandler;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getTokenFile() {
        return this.tokenFile;
    }

    @Generated
    public String getCustomerid() {
        return this.customerid;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getProxy() {
        return this.proxy;
    }

    @Generated
    public String getWorkspacepath() {
        return this.workspacepath;
    }

    @Generated
    public boolean isCreateBuildSessionId() {
        return this.createBuildSessionId;
    }

    @Generated
    public String getBuildSessionId() {
        return this.buildSessionId;
    }

    @Generated
    public String getBuildSessionIdFile() {
        return this.buildSessionIdFile;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public boolean isModuleNameArtifactId() {
        return this.moduleNameArtifactId;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getBuild() {
        return this.build;
    }

    @Generated
    public String getPackagesincluded() {
        return this.packagesincluded;
    }

    @Generated
    public String getPackagesexcluded() {
        return this.packagesexcluded;
    }

    @Generated
    public boolean isCreatePRBuildSessionId() {
        return this.createPRBuildSessionId;
    }

    @Generated
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Generated
    public int getPullRequestNumber() {
        return this.pullRequestNumber;
    }

    @Generated
    public String getLatestCommit() {
        return this.latestCommit;
    }

    @Generated
    public String getTargetBranch() {
        return this.targetBranch;
    }

    @Generated
    public String getFilesincluded() {
        return this.filesincluded;
    }

    @Generated
    public String getFilesexcluded() {
        return this.filesexcluded;
    }

    @Generated
    public boolean isRecursive() {
        return this.recursive;
    }

    @Generated
    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Generated
    public boolean isLogPluginMinimal() {
        return this.logPluginMinimal;
    }

    @Generated
    public String getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public boolean isLogToFile() {
        return this.logToFile;
    }

    @Generated
    public boolean isLogToConsole() {
        return this.logToConsole;
    }

    @Generated
    public String getLogFolder() {
        return this.logFolder;
    }

    @Generated
    public String getJavaPath() {
        return this.javaPath;
    }

    @Generated
    public String getFilesStorage() {
        return this.filesStorage;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, ?> getSealightsJvmParams() {
        return this.sealightsJvmParams;
    }

    @Generated
    public String getOverrideMetaJsonPath() {
        return this.overrideMetaJsonPath;
    }

    @Generated
    public boolean isIncludeResources() {
        return this.includeResources;
    }

    @Generated
    public boolean isIncludeTokenResource() {
        return this.includeTokenResource;
    }

    @Generated
    public String getBuildScannerJar() {
        return this.buildScannerJar;
    }

    @Generated
    public String getTestListenerJar() {
        return this.testListenerJar;
    }

    @Generated
    public String getTestStage() {
        return this.testStage;
    }

    @Generated
    public String getLabId() {
        return this.labId;
    }

    @Generated
    public boolean isCreateExecutionId() {
        return this.createExecutionId;
    }

    @Generated
    public boolean isRunTestOnly() {
        return this.runTestOnly;
    }

    @Generated
    public boolean isRunScanOnly() {
        return this.runScanOnly;
    }

    @Generated
    public boolean isRunFunctionalTests() {
        return this.runFunctionalTests;
    }

    @Generated
    public MavenSession getSession() {
        return this.session;
    }

    @Generated
    public String getSealightsPluginVersion() {
        return this.sealightsPluginVersion;
    }

    @Generated
    public void setPluginEngine(PluginEngine pluginEngine) {
        this.pluginEngine = pluginEngine;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public void setPluginsHandler(PluginsHandler pluginsHandler) {
        this.pluginsHandler = pluginsHandler;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
    }

    @Generated
    public void setCustomerid(String customerid) {
        this.customerid = customerid;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setWorkspacepath(String workspacepath) {
        this.workspacepath = workspacepath;
    }

    @Generated
    public void setCreateBuildSessionId(boolean createBuildSessionId) {
        this.createBuildSessionId = createBuildSessionId;
    }

    @Generated
    public void setBuildSessionId(String buildSessionId) {
        this.buildSessionId = buildSessionId;
    }

    @Generated
    public void setBuildSessionIdFile(String buildSessionIdFile) {
        this.buildSessionIdFile = buildSessionIdFile;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setModuleNameArtifactId(boolean moduleNameArtifactId) {
        this.moduleNameArtifactId = moduleNameArtifactId;
    }

    @Generated
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Generated
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Generated
    public void setBuild(String build) {
        this.build = build;
    }

    @Generated
    public void setPackagesincluded(String packagesincluded) {
        this.packagesincluded = packagesincluded;
    }

    @Generated
    public void setPackagesexcluded(String packagesexcluded) {
        this.packagesexcluded = packagesexcluded;
    }

    @Generated
    public void setCreatePRBuildSessionId(boolean createPRBuildSessionId) {
        this.createPRBuildSessionId = createPRBuildSessionId;
    }

    @Generated
    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @Generated
    public void setPullRequestNumber(int pullRequestNumber) {
        this.pullRequestNumber = pullRequestNumber;
    }

    @Generated
    public void setLatestCommit(String latestCommit) {
        this.latestCommit = latestCommit;
    }

    @Generated
    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    @Generated
    public void setFilesincluded(String filesincluded) {
        this.filesincluded = filesincluded;
    }

    @Generated
    public void setFilesexcluded(String filesexcluded) {
        this.filesexcluded = filesexcluded;
    }

    @Generated
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Generated
    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    @Generated
    public void setLogPluginMinimal(boolean logPluginMinimal) {
        this.logPluginMinimal = logPluginMinimal;
    }

    @Generated
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Generated
    public void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
    }

    @Generated
    public void setLogToConsole(boolean logToConsole) {
        this.logToConsole = logToConsole;
    }

    @Generated
    public void setLogFolder(String logFolder) {
        this.logFolder = logFolder;
    }

    @Generated
    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    @Generated
    public void setFilesStorage(String filesStorage) {
        this.filesStorage = filesStorage;
    }

    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setSealightsJvmParams(Map<String, ?> sealightsJvmParams) {
        this.sealightsJvmParams = sealightsJvmParams;
    }

    @Generated
    public void setOverrideMetaJsonPath(String overrideMetaJsonPath) {
        this.overrideMetaJsonPath = overrideMetaJsonPath;
    }

    @Generated
    public void setIncludeResources(boolean includeResources) {
        this.includeResources = includeResources;
    }

    @Generated
    public void setIncludeTokenResource(boolean includeTokenResource) {
        this.includeTokenResource = includeTokenResource;
    }

    @Generated
    public void setBuildScannerJar(String buildScannerJar) {
        this.buildScannerJar = buildScannerJar;
    }

    @Generated
    public void setTestListenerJar(String testListenerJar) {
        this.testListenerJar = testListenerJar;
    }

    @Generated
    public void setTestStage(String testStage) {
        this.testStage = testStage;
    }

    @Generated
    public void setLabId(String labId) {
        this.labId = labId;
    }

    @Generated
    public void setCreateExecutionId(boolean createExecutionId) {
        this.createExecutionId = createExecutionId;
    }

    @Generated
    public void setRunTestOnly(boolean runTestOnly) {
        this.runTestOnly = runTestOnly;
    }

    @Generated
    public void setRunScanOnly(boolean runScanOnly) {
        this.runScanOnly = runScanOnly;
    }

    @Generated
    public void setRunFunctionalTests(boolean runFunctionalTests) {
        this.runFunctionalTests = runFunctionalTests;
    }

    @Generated
    public void setSession(MavenSession session) {
        this.session = session;
    }

    @Generated
    public void setSealightsPluginVersion(String sealightsPluginVersion) {
        this.sealightsPluginVersion = sealightsPluginVersion;
    }

    @Generated
    public void setParams(PluginParameters params) {
        this.params = params;
    }

    @Generated
    public String toString() {
        return "SeaLightsMojo(pluginEngine=" + this.getPluginEngine() + ", logger=" + this.getLogger() + ", pluginsHandler=" + this.getPluginsHandler() + ", project=" + this.getProject() + ", token=" + this.getToken() + ", tokenFile=" + this.getTokenFile() + ", customerid=" + this.getCustomerid() + ", server=" + this.getServer() + ", proxy=" + this.getProxy() + ", workspacepath=" + this.getWorkspacepath() + ", createBuildSessionId=" + this.isCreateBuildSessionId() + ", buildSessionId=" + this.getBuildSessionId() + ", buildSessionIdFile=" + this.getBuildSessionIdFile() + ", appName=" + this.getAppName() + ", moduleNameArtifactId=" + this.isModuleNameArtifactId() + ", environment=" + this.getEnvironment() + ", branch=" + this.getBranch() + ", build=" + this.getBuild() + ", packagesincluded=" + this.getPackagesincluded() + ", packagesexcluded=" + this.getPackagesexcluded() + ", createPRBuildSessionId=" + this.isCreatePRBuildSessionId() + ", repositoryUrl=" + this.getRepositoryUrl() + ", pullRequestNumber=" + this.getPullRequestNumber() + ", latestCommit=" + this.getLatestCommit() + ", targetBranch=" + this.getTargetBranch() + ", filesincluded=" + this.getFilesincluded() + ", filesexcluded=" + this.getFilesexcluded() + ", recursive=" + this.isRecursive() + ", logEnabled=" + this.isLogEnabled() + ", logPluginMinimal=" + this.isLogPluginMinimal() + ", logLevel=" + this.getLogLevel() + ", logToFile=" + this.isLogToFile() + ", logToConsole=" + this.isLogToConsole() + ", logFolder=" + this.getLogFolder() + ", javaPath=" + this.getJavaPath() + ", filesStorage=" + this.getFilesStorage() + ", metadata=" + this.getMetadata() + ", sealightsJvmParams=" + this.getSealightsJvmParams() + ", overrideMetaJsonPath=" + this.getOverrideMetaJsonPath() + ", includeResources=" + this.isIncludeResources() + ", includeTokenResource=" + this.isIncludeTokenResource() + ", buildScannerJar=" + this.getBuildScannerJar() + ", testListenerJar=" + this.getTestListenerJar() + ", testStage=" + this.getTestStage() + ", labId=" + this.getLabId() + ", createExecutionId=" + this.isCreateExecutionId() + ", runTestOnly=" + this.isRunTestOnly() + ", runScanOnly=" + this.isRunScanOnly() + ", runFunctionalTests=" + this.isRunFunctionalTests() + ", session=" + this.getSession() + ", sealightsPluginVersion=" + this.getSealightsPluginVersion() + ", params=" + this.getParams() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeaLightsMojo)) {
            return false;
        }
        SeaLightsMojo other = (SeaLightsMojo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PluginEngine this$pluginEngine = this.getPluginEngine();
        PluginEngine other$pluginEngine = other.getPluginEngine();
        if (this$pluginEngine == null ? other$pluginEngine != null : !this$pluginEngine.equals(other$pluginEngine)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        PluginsHandler this$pluginsHandler = this.getPluginsHandler();
        PluginsHandler other$pluginsHandler = other.getPluginsHandler();
        if (this$pluginsHandler == null ? other$pluginsHandler != null : !this$pluginsHandler.equals(other$pluginsHandler)) {
            return false;
        }
        MavenProject this$project = this.getProject();
        MavenProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$tokenFile = this.getTokenFile();
        String other$tokenFile = other.getTokenFile();
        if (this$tokenFile == null ? other$tokenFile != null : !this$tokenFile.equals(other$tokenFile)) {
            return false;
        }
        String this$customerid = this.getCustomerid();
        String other$customerid = other.getCustomerid();
        if (this$customerid == null ? other$customerid != null : !this$customerid.equals(other$customerid)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        String this$workspacepath = this.getWorkspacepath();
        String other$workspacepath = other.getWorkspacepath();
        if (this$workspacepath == null ? other$workspacepath != null : !this$workspacepath.equals(other$workspacepath)) {
            return false;
        }
        if (this.isCreateBuildSessionId() != other.isCreateBuildSessionId()) {
            return false;
        }
        String this$buildSessionId = this.getBuildSessionId();
        String other$buildSessionId = other.getBuildSessionId();
        if (this$buildSessionId == null ? other$buildSessionId != null : !this$buildSessionId.equals(other$buildSessionId)) {
            return false;
        }
        String this$buildSessionIdFile = this.getBuildSessionIdFile();
        String other$buildSessionIdFile = other.getBuildSessionIdFile();
        if (this$buildSessionIdFile == null ? other$buildSessionIdFile != null : !this$buildSessionIdFile.equals(other$buildSessionIdFile)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        if (this.isModuleNameArtifactId() != other.isModuleNameArtifactId()) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$packagesincluded = this.getPackagesincluded();
        String other$packagesincluded = other.getPackagesincluded();
        if (this$packagesincluded == null ? other$packagesincluded != null : !this$packagesincluded.equals(other$packagesincluded)) {
            return false;
        }
        String this$packagesexcluded = this.getPackagesexcluded();
        String other$packagesexcluded = other.getPackagesexcluded();
        if (this$packagesexcluded == null ? other$packagesexcluded != null : !this$packagesexcluded.equals(other$packagesexcluded)) {
            return false;
        }
        if (this.isCreatePRBuildSessionId() != other.isCreatePRBuildSessionId()) {
            return false;
        }
        String this$repositoryUrl = this.getRepositoryUrl();
        String other$repositoryUrl = other.getRepositoryUrl();
        if (this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl)) {
            return false;
        }
        if (this.getPullRequestNumber() != other.getPullRequestNumber()) {
            return false;
        }
        String this$latestCommit = this.getLatestCommit();
        String other$latestCommit = other.getLatestCommit();
        if (this$latestCommit == null ? other$latestCommit != null : !this$latestCommit.equals(other$latestCommit)) {
            return false;
        }
        String this$targetBranch = this.getTargetBranch();
        String other$targetBranch = other.getTargetBranch();
        if (this$targetBranch == null ? other$targetBranch != null : !this$targetBranch.equals(other$targetBranch)) {
            return false;
        }
        String this$filesincluded = this.getFilesincluded();
        String other$filesincluded = other.getFilesincluded();
        if (this$filesincluded == null ? other$filesincluded != null : !this$filesincluded.equals(other$filesincluded)) {
            return false;
        }
        String this$filesexcluded = this.getFilesexcluded();
        String other$filesexcluded = other.getFilesexcluded();
        if (this$filesexcluded == null ? other$filesexcluded != null : !this$filesexcluded.equals(other$filesexcluded)) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        if (this.isLogEnabled() != other.isLogEnabled()) {
            return false;
        }
        if (this.isLogPluginMinimal() != other.isLogPluginMinimal()) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        if (this.isLogToFile() != other.isLogToFile()) {
            return false;
        }
        if (this.isLogToConsole() != other.isLogToConsole()) {
            return false;
        }
        String this$logFolder = this.getLogFolder();
        String other$logFolder = other.getLogFolder();
        if (this$logFolder == null ? other$logFolder != null : !this$logFolder.equals(other$logFolder)) {
            return false;
        }
        String this$javaPath = this.getJavaPath();
        String other$javaPath = other.getJavaPath();
        if (this$javaPath == null ? other$javaPath != null : !this$javaPath.equals(other$javaPath)) {
            return false;
        }
        String this$filesStorage = this.getFilesStorage();
        String other$filesStorage = other.getFilesStorage();
        if (this$filesStorage == null ? other$filesStorage != null : !this$filesStorage.equals(other$filesStorage)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, ?> this$sealightsJvmParams = this.getSealightsJvmParams();
        Map<String, ?> other$sealightsJvmParams = other.getSealightsJvmParams();
        if (this$sealightsJvmParams == null ? other$sealightsJvmParams != null : !((Object)this$sealightsJvmParams).equals(other$sealightsJvmParams)) {
            return false;
        }
        String this$overrideMetaJsonPath = this.getOverrideMetaJsonPath();
        String other$overrideMetaJsonPath = other.getOverrideMetaJsonPath();
        if (this$overrideMetaJsonPath == null ? other$overrideMetaJsonPath != null : !this$overrideMetaJsonPath.equals(other$overrideMetaJsonPath)) {
            return false;
        }
        if (this.isIncludeResources() != other.isIncludeResources()) {
            return false;
        }
        if (this.isIncludeTokenResource() != other.isIncludeTokenResource()) {
            return false;
        }
        String this$buildScannerJar = this.getBuildScannerJar();
        String other$buildScannerJar = other.getBuildScannerJar();
        if (this$buildScannerJar == null ? other$buildScannerJar != null : !this$buildScannerJar.equals(other$buildScannerJar)) {
            return false;
        }
        String this$testListenerJar = this.getTestListenerJar();
        String other$testListenerJar = other.getTestListenerJar();
        if (this$testListenerJar == null ? other$testListenerJar != null : !this$testListenerJar.equals(other$testListenerJar)) {
            return false;
        }
        String this$testStage = this.getTestStage();
        String other$testStage = other.getTestStage();
        if (this$testStage == null ? other$testStage != null : !this$testStage.equals(other$testStage)) {
            return false;
        }
        String this$labId = this.getLabId();
        String other$labId = other.getLabId();
        if (this$labId == null ? other$labId != null : !this$labId.equals(other$labId)) {
            return false;
        }
        if (this.isCreateExecutionId() != other.isCreateExecutionId()) {
            return false;
        }
        if (this.isRunTestOnly() != other.isRunTestOnly()) {
            return false;
        }
        if (this.isRunScanOnly() != other.isRunScanOnly()) {
            return false;
        }
        if (this.isRunFunctionalTests() != other.isRunFunctionalTests()) {
            return false;
        }
        MavenSession this$session = this.getSession();
        MavenSession other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        String this$sealightsPluginVersion = this.getSealightsPluginVersion();
        String other$sealightsPluginVersion = other.getSealightsPluginVersion();
        if (this$sealightsPluginVersion == null ? other$sealightsPluginVersion != null : !this$sealightsPluginVersion.equals(other$sealightsPluginVersion)) {
            return false;
        }
        PluginParameters this$params = this.getParams();
        PluginParameters other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SeaLightsMojo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PluginEngine $pluginEngine = this.getPluginEngine();
        result = result * 59 + ($pluginEngine == null ? 43 : $pluginEngine.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        PluginsHandler $pluginsHandler = this.getPluginsHandler();
        result = result * 59 + ($pluginsHandler == null ? 43 : $pluginsHandler.hashCode());
        MavenProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $tokenFile = this.getTokenFile();
        result = result * 59 + ($tokenFile == null ? 43 : $tokenFile.hashCode());
        String $customerid = this.getCustomerid();
        result = result * 59 + ($customerid == null ? 43 : $customerid.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        String $workspacepath = this.getWorkspacepath();
        result = result * 59 + ($workspacepath == null ? 43 : $workspacepath.hashCode());
        result = result * 59 + (this.isCreateBuildSessionId() ? 79 : 97);
        String $buildSessionId = this.getBuildSessionId();
        result = result * 59 + ($buildSessionId == null ? 43 : $buildSessionId.hashCode());
        String $buildSessionIdFile = this.getBuildSessionIdFile();
        result = result * 59 + ($buildSessionIdFile == null ? 43 : $buildSessionIdFile.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        result = result * 59 + (this.isModuleNameArtifactId() ? 79 : 97);
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $packagesincluded = this.getPackagesincluded();
        result = result * 59 + ($packagesincluded == null ? 43 : $packagesincluded.hashCode());
        String $packagesexcluded = this.getPackagesexcluded();
        result = result * 59 + ($packagesexcluded == null ? 43 : $packagesexcluded.hashCode());
        result = result * 59 + (this.isCreatePRBuildSessionId() ? 79 : 97);
        String $repositoryUrl = this.getRepositoryUrl();
        result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
        result = result * 59 + this.getPullRequestNumber();
        String $latestCommit = this.getLatestCommit();
        result = result * 59 + ($latestCommit == null ? 43 : $latestCommit.hashCode());
        String $targetBranch = this.getTargetBranch();
        result = result * 59 + ($targetBranch == null ? 43 : $targetBranch.hashCode());
        String $filesincluded = this.getFilesincluded();
        result = result * 59 + ($filesincluded == null ? 43 : $filesincluded.hashCode());
        String $filesexcluded = this.getFilesexcluded();
        result = result * 59 + ($filesexcluded == null ? 43 : $filesexcluded.hashCode());
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        result = result * 59 + (this.isLogEnabled() ? 79 : 97);
        result = result * 59 + (this.isLogPluginMinimal() ? 79 : 97);
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        result = result * 59 + (this.isLogToFile() ? 79 : 97);
        result = result * 59 + (this.isLogToConsole() ? 79 : 97);
        String $logFolder = this.getLogFolder();
        result = result * 59 + ($logFolder == null ? 43 : $logFolder.hashCode());
        String $javaPath = this.getJavaPath();
        result = result * 59 + ($javaPath == null ? 43 : $javaPath.hashCode());
        String $filesStorage = this.getFilesStorage();
        result = result * 59 + ($filesStorage == null ? 43 : $filesStorage.hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, ?> $sealightsJvmParams = this.getSealightsJvmParams();
        result = result * 59 + ($sealightsJvmParams == null ? 43 : ((Object)$sealightsJvmParams).hashCode());
        String $overrideMetaJsonPath = this.getOverrideMetaJsonPath();
        result = result * 59 + ($overrideMetaJsonPath == null ? 43 : $overrideMetaJsonPath.hashCode());
        result = result * 59 + (this.isIncludeResources() ? 79 : 97);
        result = result * 59 + (this.isIncludeTokenResource() ? 79 : 97);
        String $buildScannerJar = this.getBuildScannerJar();
        result = result * 59 + ($buildScannerJar == null ? 43 : $buildScannerJar.hashCode());
        String $testListenerJar = this.getTestListenerJar();
        result = result * 59 + ($testListenerJar == null ? 43 : $testListenerJar.hashCode());
        String $testStage = this.getTestStage();
        result = result * 59 + ($testStage == null ? 43 : $testStage.hashCode());
        String $labId = this.getLabId();
        result = result * 59 + ($labId == null ? 43 : $labId.hashCode());
        result = result * 59 + (this.isCreateExecutionId() ? 79 : 97);
        result = result * 59 + (this.isRunTestOnly() ? 79 : 97);
        result = result * 59 + (this.isRunScanOnly() ? 79 : 97);
        result = result * 59 + (this.isRunFunctionalTests() ? 79 : 97);
        MavenSession $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        String $sealightsPluginVersion = this.getSealightsPluginVersion();
        result = result * 59 + ($sealightsPluginVersion == null ? 43 : $sealightsPluginVersion.hashCode());
        PluginParameters $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @Generated
    public MavenProject getProject() {
        return this.project;
    }
}

