/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin;

import io.sealights.onpremise.agents.plugin.SeaLightsMojo;
import io.sealights.plugins.engine.api.PluginParameters;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="listener")
public class TstListnrMojo
extends SeaLightsMojo {
    private boolean testListenerEnabled;
    private String testListenerConfigFile;
    private Map<String, ?> testListenerJvmParams;
    private String classLoadersExcluded;
    private String overrideTestListenerPath;
    private boolean testListenerIgnoreLogEnabled;

    @Override
    public void initParams() {
        super.initParams();
        PluginParameters.TstLisnrParams tstListnrParams = new PluginParameters.TstLisnrParams();
        tstListnrParams.setTestListenerEnabled(this.testListenerEnabled);
        tstListnrParams.setTestListenerConfigFile(this.testListenerConfigFile);
        tstListnrParams.setTestListenerJvmParams(this.testListenerJvmParams);
        tstListnrParams.setClassLoadersExcluded(this.classLoadersExcluded);
        tstListnrParams.setTestListenerIgnoreLogEnabled(this.testListenerIgnoreLogEnabled);
        this.getParams().setTstListnrParams(tstListnrParams);
    }

    @Override
    protected boolean executePluginGoal() {
        boolean result = this.getPluginEngine().executeTstLisnrGoal(this).isOk();
        return result;
    }

    @Override
    public void onFailure() {
        super.onFailure();
        String error = String.format("module:'%s' - test-istener was not configured due to invalid surefire configuration", this.getModuleName());
        BuildLifeCycle.notifyError(error);
        this.getLogger().warn(error);
    }

    @Override
    public boolean postExecute() {
        if (this.isRunScanOnly()) {
            return true;
        }
        if (this.getPluginsHandler().isValidConfiguration()) {
            this.setTstLsnrPathSysProperty();
            this.getPluginsHandler().updateProperties(this.getExecData().getTstLisnrCliData(this.getModuleName()).getMavenPluginTstLisnrCli(), this.getExecData().getToken(), true);
            return this.testListenerEnabled;
        }
        return false;
    }

    @Override
    protected String getMojoName() {
        return "test listener";
    }

    private void setTstLsnrPathSysProperty() {
        if (this.getProject() != null && this.getProject().getProperties() != null) {
            this.getProject().getProperties().setProperty("sl.testListenerPath", this.getExecData().getTstLisnrLocation());
        }
    }
}

