/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin.logging;

import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFormatAdapter;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;

public class MavenLogWrapper
extends MarkerIgnoringBase
implements Logger {
    static final String PLUGIN_TAG = "- [Sealights Maven Plugin] - ";
    private final Log log;
    private final boolean enabled;

    public MavenLogWrapper(Log log, boolean enabled) {
        this.log = log;
        this.enabled = enabled;
    }

    public boolean isTraceEnabled() {
        return this.enabled;
    }

    public boolean isDebugEnabled() {
        return this.enabled;
    }

    public boolean isInfoEnabled() {
        return this.enabled;
    }

    public boolean isWarnEnabled() {
        return this.enabled;
    }

    public boolean isErrorEnabled() {
        return this.enabled;
    }

    public void trace(String string) {
        this.delegate(Level.TRACE, string);
    }

    public void trace(String format, Object arg) {
        this.delegate(Level.TRACE, LogFormatAdapter.normalizedMessage(format, arg));
    }

    public void trace(String format, Object ... args) {
        this.delegate(Level.TRACE, LogFormatAdapter.normalizedMessage(format, args));
    }

    public void debug(String string) {
        this.delegate(Level.DEBUG, string);
    }

    public void debug(String format, Object arg) {
        this.delegate(Level.DEBUG, LogFormatAdapter.normalizedMessage(format, arg));
    }

    public void debug(String format, Object ... args) {
        this.delegate(Level.DEBUG, LogFormatAdapter.normalizedMessage(format, args));
    }

    public void info(String string) {
        this.delegate(Level.INFO, string);
    }

    public void info(String format, Object arg) {
        this.delegate(Level.INFO, LogFormatAdapter.normalizedMessage(format, arg));
    }

    public void info(String format, Object ... args) {
        this.delegate(Level.INFO, LogFormatAdapter.normalizedMessage(format, args));
    }

    public void warn(String string) {
        this.delegate(Level.WARN, string);
    }

    public void warn(String format, Object arg) {
        this.delegate(Level.WARN, LogFormatAdapter.normalizedMessage(format, arg));
    }

    public void warn(String format, Object ... args) {
        this.delegate(Level.WARN, LogFormatAdapter.normalizedMessage(format, args));
    }

    public void error(String string) {
        this.delegate(Level.ERROR, string);
    }

    public void error(String format, Object arg) {
        this.delegate(Level.ERROR, LogFormatAdapter.normalizedMessage(format, arg));
    }

    public void error(String format, Object ... args) {
        this.delegate(Level.ERROR, LogFormatAdapter.normalizedMessage(format, args));
    }

    public void error(String string, Throwable e) {
        this.delegate(Level.ERROR, string, e);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.delegate(Level.WARN, LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        this.delegate(Level.WARN, msg, t);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.delegate(Level.TRACE, LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    public void trace(String msg, Throwable t) {
        this.delegate(Level.TRACE, msg, t);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.delegate(Level.DEBUG, LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    public void debug(String msg, Throwable t) {
        this.delegate(Level.DEBUG, msg, t);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.delegate(Level.INFO, LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    public void info(String msg, Throwable t) {
        this.delegate(Level.INFO, msg, t);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.delegate(Level.ERROR, LogFormatAdapter.normalizedMessage(format, arg1, arg2));
    }

    private void delegate(Level logLineLevel, CharSequence charSequence) {
        this.delegate(logLineLevel, charSequence, null);
    }

    private void delegate(Level logLineLevel, CharSequence charSequence, Throwable throwable) {
        if (this.enabled) {
            this.toMavenLog(logLineLevel, charSequence, throwable);
        }
    }

    private void toMavenLog(Level logLineLevel, CharSequence charSequence, Throwable throwable) {
        switch (logLineLevel) {
            case TRACE: 
            case DEBUG: {
                if (charSequence == null) {
                    this.log.debug((CharSequence)PLUGIN_TAG, throwable);
                    break;
                }
                if (throwable == null) {
                    this.log.debug((CharSequence)(PLUGIN_TAG + charSequence));
                    break;
                }
                this.log.debug((CharSequence)(PLUGIN_TAG + charSequence), throwable);
                break;
            }
            case INFO: {
                if (charSequence == null) {
                    this.log.info((CharSequence)PLUGIN_TAG, throwable);
                    break;
                }
                if (throwable == null) {
                    this.log.info((CharSequence)(PLUGIN_TAG + charSequence));
                    break;
                }
                this.log.info((CharSequence)(PLUGIN_TAG + charSequence), throwable);
                break;
            }
            case WARN: {
                if (charSequence == null) {
                    this.log.warn((CharSequence)PLUGIN_TAG, throwable);
                    break;
                }
                if (throwable == null) {
                    this.log.warn((CharSequence)(PLUGIN_TAG + charSequence));
                    break;
                }
                this.log.warn((CharSequence)(PLUGIN_TAG + charSequence), throwable);
                break;
            }
            case ERROR: {
                if (charSequence == null) {
                    this.log.error((CharSequence)PLUGIN_TAG, throwable);
                    break;
                }
                if (throwable == null) {
                    this.log.error((CharSequence)(PLUGIN_TAG + charSequence));
                    break;
                }
                this.log.error((CharSequence)(PLUGIN_TAG + charSequence), throwable);
            }
        }
    }
}

