/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin.surefire;

import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;

public final class PluginCfgLogger {
    private static final String LINE = "--------------------";

    static void logValidationResults(Logger log, String pluginName, ValidationResult validationResult) {
        if (!validationResult.isEmpty()) {
            PluginCfgLogger.logImportantInfo(log, pluginName + " validation result", validationResult.toStringWarnings(), validationResult.toStringErrors());
        }
    }

    static void logPluginSettings(Logger log, Properties properties, PluginConfiguration surefireConfig, PluginConfiguration failsafeConfig, String token, boolean withSealights) {
        String title = withSealights ? "surefire/failsafe settings for running with sealights" : "surefire/failsafe settings to run without sealights";
        PluginCfgLogger.logImportantInfo(log, title, surefireConfig.isEmpty() ? null : surefireConfig.toString(), failsafeConfig.isEmpty() ? null : failsafeConfig.toString(), PluginCfgLogger.toStringPropertyInfo(properties, token, "argLine"), PluginCfgLogger.toStringPropertyInfo(properties, token, "sealightsArgLine"));
    }

    static void logImportantInfo(Logger log, String title, String ... msgs) {
        log.info("{} {}: ", (Object)LINE, (Object)title);
        for (String ms : msgs) {
            if (!StringUtils.isNotEmpty(ms)) continue;
            log.info(ms);
        }
        log.info("------------------------------------------------------------");
    }

    private static String toStringPropertyInfo(Properties properties, String token, String propKey) {
        String propValue = properties.getProperty(propKey);
        if (StringUtils.isNotEmpty(propValue)) {
            return String.format("property '%s'='%s'", propKey, TokenValueFormatter.truncateTokenSysProperty(propValue, token));
        }
        return null;
    }

    @Generated
    private PluginCfgLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

