/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin.surefire;

import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.plugin.jacoco.JacocoPluginConfiguration;
import io.sealights.onpremise.agents.plugin.surefire.PluginCfgParser;
import io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Plugin;

public class PluginCfgValidator {
    public static final String SUREFIRE_OR_FAILSAFE_NOT_FOUND = "neither surefire or failsafe plugin is set, SeaLights Test Listener will not run.";
    public static final String MIN_SUREFIRE_VERSION = "2.9";
    public static final String USE_VERSIONS = "please use the version '2.9' or later.";
    public static final String UNDEFINED_VERSION = "maven-surefire-plugin version is undefined; please use the version '2.9' or later.";
    public static final String UNSUPPORTED_MIN_VERSION_FMT = "maven-surefire-plugin version '%s' is not supported; please use the version '2.9' or later.";
    public static final String WIKI_LINK_SUREFIRE_INTEGRATION = "https://sealights.atlassian.net/wiki/spaces/SUP/pages/2873655305/Java+-+How+to+configure+Surefire+integration";
    public static final String INVALID_ARG_LINE = "Incorrect 'argLine' value - the Sealights test-listener cannot be defined: @{argLine} or @{sealightsArgLine} should be added https://sealights.atlassian.net/wiki/spaces/SUP/pages/2873655305/Java+-+How+to+configure+Surefire+integration";
    public static final String ARG_LINE_PLACEHOLDER_WITH_$ = "Inaccurate 'argLine' value - the Sealights additions may be ignored; ${argLine} should be replaced by @{argLine} or @{sealightsArgLine} should be added https://sealights.atlassian.net/wiki/spaces/SUP/pages/2873655305/Java+-+How+to+configure+Surefire+integration";
    public static final String SL_ARG_LINE_PLACEHOLDER_WITH_$ = "Inaccurate 'sealightsArgLine' value - the Sealights additions may be ignored; configuration ${sealightsArgLine} should be replaced by  @{sealightsArgLine} https://sealights.atlassian.net/wiki/spaces/SUP/pages/2873655305/Java+-+How+to+configure+Surefire+integration";
    public static final String INVALID_FORK_MODE_NEVER = "Unsupported 'forkMode' value 'never'";
    public static final String INVALID_FORK_MODE_PERTHREAD = "Unsupported 'forkMode' value 'perthread', it cannot be used in combination with 'threadCount=0'";
    public static final String INVALID_FORK_COUNT = "Unsupported 'forkCount' value '0'";
    public static final String REUSE_FORKS_FALSE = "The parameter 'reuseForks=false' may affect the performance";
    public static final String PARALLEL_EXISTS = "The parameter 'parallel' may affects the coloring ";
    private final PluginConfiguration configuration;
    private ValidationResult validationResult = new ValidationResult();
    private boolean pluginExists = false;
    private boolean validateVersion;

    public static PluginCfgValidator createSurefireCfgValidator() {
        return new PluginCfgValidator(new PluginConfiguration("maven-surefire-plugin"), true);
    }

    public static PluginCfgValidator createFailsafeCfgValidator() {
        return new PluginCfgValidator(new PluginConfiguration("maven-failsafe-plugin"), false);
    }

    PluginCfgValidator(PluginConfiguration configuration, boolean validateVersion) {
        this.configuration = configuration;
        this.validateVersion = validateVersion;
    }

    public void fillAndValidateConfiguration(Plugin plugin, JacocoPluginConfiguration jacocoPluginConfiguration) {
        this.configuration.setArtifactId(plugin.getArtifactId());
        this.configuration.setVersion(plugin.getVersion());
        this.setPluginExists(true);
        if (this.validateVersion && !this.isSupportedVersion()) {
            return;
        }
        try {
            PluginCfgParser.parse(plugin, this.configuration);
        }
        catch (Exception e) {
            this.validationResult.addWarning("Partial configuration was collected, error:" + e);
        }
        this.validate();
    }

    public boolean isArgLinePropertyRelevant() {
        return this.isPluginExists() && this.shouldExecutePlugin() && this.configuration.isArgLinePropertyRelevant();
    }

    private boolean shouldExecutePlugin() {
        return this.configuration.getSkip() == null || this.configuration.getSkip() == false;
    }

    public boolean isValidConfiguration() {
        return this.validationResult.isValid();
    }

    boolean isSupportedVersion() {
        boolean supportedVersion;
        if (!this.validateVersion) {
            return true;
        }
        if (this.configuration.getVersion() == null) {
            this.validationResult.addWarning(UNDEFINED_VERSION);
            return false;
        }
        ComparableVersion current = new ComparableVersion(this.configuration.getVersion());
        boolean bl = supportedVersion = current.compareTo(new ComparableVersion(MIN_SUREFIRE_VERSION)) >= 0;
        if (!supportedVersion) {
            this.validationResult.addWarning(String.format(UNSUPPORTED_MIN_VERSION_FMT, this.configuration.getVersion()));
        }
        return supportedVersion;
    }

    boolean validate() {
        this.validateArgLine();
        this.validateForkCount();
        this.validateForkMode();
        this.validateParallel();
        this.validateReuseForks();
        return this.validationResult.isValid();
    }

    private void validateArgLine() {
        if (!this.configuration.hasArgLine()) {
            return;
        }
        boolean isArgLineDefined = this.configuration.hasArgLinePlaceholder();
        boolean isSealightsArgLineDefined = this.configuration.hasSealightsPlaceholder();
        if (!isArgLineDefined && !isSealightsArgLineDefined) {
            this.validationResult.addError(INVALID_ARG_LINE);
            return;
        }
        if (!isSealightsArgLineDefined) {
            this.validateArgLinePlaceholder();
        } else {
            this.validateSealightsArgLinePlaceholder();
        }
    }

    private void validateArgLinePlaceholder() {
        if (!this.configuration.isArgLinePlaceholderWithAtSymbol()) {
            this.validationResult.addWarning(ARG_LINE_PLACEHOLDER_WITH_$);
        }
    }

    private void validateSealightsArgLinePlaceholder() {
        if (!this.configuration.isSealightsPlaceholderWithAtSymbol()) {
            this.validationResult.addWarning(SL_ARG_LINE_PLACEHOLDER_WITH_$);
        }
    }

    protected void validateForkMode() {
        String forkMode = this.configuration.getForkMode();
        if (forkMode == null) {
            return;
        }
        if (PluginConfiguration.InvalidForkmode.never.name().equals(forkMode)) {
            this.validationResult.addError(INVALID_FORK_MODE_NEVER);
        }
        if (PluginConfiguration.InvalidForkmode.perthread.name().equals(forkMode) && this.isValueOfZero(this.configuration.getThreadCount())) {
            this.validationResult.addError(INVALID_FORK_MODE_PERTHREAD);
        }
    }

    protected void validateForkCount() {
        if (this.isValueOfZero(this.configuration.getForkCount())) {
            this.validationResult.addError(INVALID_FORK_COUNT);
        }
    }

    protected void validateReuseForks() {
        if (this.configuration.getReuseForks() != null && !this.configuration.getReuseForks().booleanValue()) {
            this.validationResult.addWarning(REUSE_FORKS_FALSE);
        }
    }

    protected void validateParallel() {
        if (StringUtils.isNotEmpty(this.configuration.getParallel())) {
            this.validationResult.addWarning(PARALLEL_EXISTS);
        }
    }

    private boolean isValueOfZero(Integer value) {
        return value != null && value == 0;
    }

    @Generated
    public PluginConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Generated
    public boolean isPluginExists() {
        return this.pluginExists;
    }

    @Generated
    public void setPluginExists(boolean pluginExists) {
        this.pluginExists = pluginExists;
    }
}

