/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin.surefire;

import lombok.Generated;

public class PluginConfiguration {
    public static final String SUREFIRE_ARTIFACT_ID = "maven-surefire-plugin";
    public static final String FAILSAFE_ARTIFACT_ID = "maven-failsafe-plugin";
    public static final String APACHE_MAVEN_PLUGIN_GROUP = "org.apache.maven.plugins";
    public static final String ARG_LINE = "argLine";
    public static final String SKIP = "skip";
    public static final String REUSE_FORKS = "reuseForks";
    public static final String FORK_COUNT = "forkCount";
    public static final String THREAD_COUNT = "threadCount";
    public static final String FORK_MODE = "forkMode";
    public static final String PARALLEL = "parallel";
    public static final String ARG_LINE_PLACEHOLDER = "{argLine}";
    private static final String SL_ARG_LINE_PLACEHOLDER = "{sealightsArgLine}";
    private static final String AT = "@";
    private String artifactId;
    private String version;
    private String argLine;
    private Boolean skip;
    private Boolean reuseForks;
    private Integer forkCount;
    private Integer threadCount;
    private String forkMode;
    private String parallel;
    private String jacocoPropertyName;
    private String jacocoPropertyPlaceholder;

    public static PluginConfiguration createSurefireConfiguration(String jacocoPropertyName) {
        return new PluginConfiguration(SUREFIRE_ARTIFACT_ID, jacocoPropertyName);
    }

    static PluginConfiguration createSurefireConfiguration() {
        return PluginConfiguration.createSurefireConfiguration(ARG_LINE);
    }

    public static PluginConfiguration createFailsafeConfiguration(String jacocoPropertyName) {
        return new PluginConfiguration(FAILSAFE_ARTIFACT_ID, jacocoPropertyName);
    }

    static PluginConfiguration createFailsafeConfiguration() {
        return PluginConfiguration.createFailsafeConfiguration(ARG_LINE);
    }

    PluginConfiguration(String artifactId, String jacocoPropertyName) {
        this.artifactId = artifactId;
        this.setJacocoPropertyName(jacocoPropertyName);
    }

    PluginConfiguration(String artifactId) {
        this(artifactId, ARG_LINE);
    }

    public boolean isEmpty() {
        return this.version == null;
    }

    public boolean isArgLinePropertyRelevant() {
        return !this.hasArgLine() || !this.hasSealightsPlaceholder() && this.hasArgLinePlaceholder();
    }

    public boolean hasArgLine() {
        return this.argLine != null;
    }

    public boolean hasArgLinePlaceholder() {
        return this.hasPlaceholder(ARG_LINE_PLACEHOLDER);
    }

    public boolean hasJacocoPropertyPlaceholder() {
        return this.hasPlaceholder(this.jacocoPropertyPlaceholder);
    }

    public boolean hasSealightsPlaceholder() {
        return this.hasPlaceholder(SL_ARG_LINE_PLACEHOLDER);
    }

    public boolean isArgLinePlaceholderWithAtSymbol() {
        return this.isPlaceholderWithAtSymbol(ARG_LINE_PLACEHOLDER);
    }

    private boolean hasPlaceholder(String placeholder) {
        return this.argLine != null && this.argLine.contains(placeholder);
    }

    public boolean isSealightsPlaceholderWithAtSymbol() {
        return this.isPlaceholderWithAtSymbol(SL_ARG_LINE_PLACEHOLDER);
    }

    private boolean isPlaceholderWithAtSymbol(String placeholder) {
        if (this.argLine == null || placeholder == null) {
            return true;
        }
        return this.argLine.contains(AT + placeholder);
    }

    public void setJacocoPropertyName(String jacocoPropertyName) {
        this.jacocoPropertyName = jacocoPropertyName;
        this.jacocoPropertyPlaceholder = "{" + jacocoPropertyName + "}";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.artifactId).append(" configuration: ");
        builder.append("[version=").append(this.version);
        if (this.argLine != null) {
            builder.append(", argLine='").append(this.argLine).append("'");
        }
        if (this.reuseForks != null) {
            builder.append(", reuseForks=").append(this.reuseForks);
        }
        if (this.forkCount != null) {
            builder.append(", forkCount=").append(this.forkCount);
        }
        if (this.threadCount != null) {
            builder.append(", threadCount=").append(this.threadCount);
        }
        if (this.forkMode != null) {
            builder.append(", forkMode=").append(this.forkMode);
        }
        if (this.parallel != null) {
            builder.append(", parallel=").append(this.parallel);
        }
        builder.append("]");
        return builder.toString();
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getArgLine() {
        return this.argLine;
    }

    @Generated
    public Boolean getSkip() {
        return this.skip;
    }

    @Generated
    public Boolean getReuseForks() {
        return this.reuseForks;
    }

    @Generated
    public Integer getForkCount() {
        return this.forkCount;
    }

    @Generated
    public Integer getThreadCount() {
        return this.threadCount;
    }

    @Generated
    public String getForkMode() {
        return this.forkMode;
    }

    @Generated
    public String getParallel() {
        return this.parallel;
    }

    @Generated
    public String getJacocoPropertyName() {
        return this.jacocoPropertyName;
    }

    @Generated
    public String getJacocoPropertyPlaceholder() {
        return this.jacocoPropertyPlaceholder;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    @Generated
    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    @Generated
    public void setReuseForks(Boolean reuseForks) {
        this.reuseForks = reuseForks;
    }

    @Generated
    public void setForkCount(Integer forkCount) {
        this.forkCount = forkCount;
    }

    @Generated
    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    @Generated
    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    @Generated
    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    @Generated
    public void setJacocoPropertyPlaceholder(String jacocoPropertyPlaceholder) {
        this.jacocoPropertyPlaceholder = jacocoPropertyPlaceholder;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginConfiguration)) {
            return false;
        }
        PluginConfiguration other = (PluginConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$argLine = this.getArgLine();
        String other$argLine = other.getArgLine();
        if (this$argLine == null ? other$argLine != null : !this$argLine.equals(other$argLine)) {
            return false;
        }
        Boolean this$skip = this.getSkip();
        Boolean other$skip = other.getSkip();
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        Boolean this$reuseForks = this.getReuseForks();
        Boolean other$reuseForks = other.getReuseForks();
        if (this$reuseForks == null ? other$reuseForks != null : !((Object)this$reuseForks).equals(other$reuseForks)) {
            return false;
        }
        Integer this$forkCount = this.getForkCount();
        Integer other$forkCount = other.getForkCount();
        if (this$forkCount == null ? other$forkCount != null : !((Object)this$forkCount).equals(other$forkCount)) {
            return false;
        }
        Integer this$threadCount = this.getThreadCount();
        Integer other$threadCount = other.getThreadCount();
        if (this$threadCount == null ? other$threadCount != null : !((Object)this$threadCount).equals(other$threadCount)) {
            return false;
        }
        String this$forkMode = this.getForkMode();
        String other$forkMode = other.getForkMode();
        if (this$forkMode == null ? other$forkMode != null : !this$forkMode.equals(other$forkMode)) {
            return false;
        }
        String this$parallel = this.getParallel();
        String other$parallel = other.getParallel();
        if (this$parallel == null ? other$parallel != null : !this$parallel.equals(other$parallel)) {
            return false;
        }
        String this$jacocoPropertyName = this.getJacocoPropertyName();
        String other$jacocoPropertyName = other.getJacocoPropertyName();
        if (this$jacocoPropertyName == null ? other$jacocoPropertyName != null : !this$jacocoPropertyName.equals(other$jacocoPropertyName)) {
            return false;
        }
        String this$jacocoPropertyPlaceholder = this.getJacocoPropertyPlaceholder();
        String other$jacocoPropertyPlaceholder = other.getJacocoPropertyPlaceholder();
        return !(this$jacocoPropertyPlaceholder == null ? other$jacocoPropertyPlaceholder != null : !this$jacocoPropertyPlaceholder.equals(other$jacocoPropertyPlaceholder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $argLine = this.getArgLine();
        result = result * 59 + ($argLine == null ? 43 : $argLine.hashCode());
        Boolean $skip = this.getSkip();
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        Boolean $reuseForks = this.getReuseForks();
        result = result * 59 + ($reuseForks == null ? 43 : ((Object)$reuseForks).hashCode());
        Integer $forkCount = this.getForkCount();
        result = result * 59 + ($forkCount == null ? 43 : ((Object)$forkCount).hashCode());
        Integer $threadCount = this.getThreadCount();
        result = result * 59 + ($threadCount == null ? 43 : ((Object)$threadCount).hashCode());
        String $forkMode = this.getForkMode();
        result = result * 59 + ($forkMode == null ? 43 : $forkMode.hashCode());
        String $parallel = this.getParallel();
        result = result * 59 + ($parallel == null ? 43 : $parallel.hashCode());
        String $jacocoPropertyName = this.getJacocoPropertyName();
        result = result * 59 + ($jacocoPropertyName == null ? 43 : $jacocoPropertyName.hashCode());
        String $jacocoPropertyPlaceholder = this.getJacocoPropertyPlaceholder();
        result = result * 59 + ($jacocoPropertyPlaceholder == null ? 43 : $jacocoPropertyPlaceholder.hashCode());
        return result;
    }

    static enum InvalidForkmode {
        perthread,
        never;

    }
}

