/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.plugin.surefire;

import io.sealights.onpremise.agents.infra.constants.SLProperties;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.plugin.jacoco.JacocoPluginConfiguration;
import io.sealights.onpremise.agents.plugin.jacoco.JacocoPluginHandler;
import io.sealights.onpremise.agents.plugin.surefire.PluginCfgLogger;
import io.sealights.onpremise.agents.plugin.surefire.PluginCfgValidator;
import io.sealights.onpremise.agents.plugin.surefire.PluginConfiguration;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;

public class PluginsHandler {
    public static final String SL_TEST_LISTENER = "sl-test-listener";
    public static final String JAVA_TEST_LISTENER = "java-test-listener";
    public static final String DEV_SL_TEST_LISTENER = "java-agent-bootstrapper-1.0.0-SNAPSHOT";
    public static final String SEALIGHTS_ARG_LINE = "sealightsArgLine";
    public static final String SEALIGHTS_DISABLED = SLProperties.toJvmAgr("sl.enabled", "false");
    private MavenProject project;
    private Logger logger;
    private boolean pluginsDiscovered;
    private JacocoPluginConfiguration jacocoPluginConfiguration;
    private PluginCfgValidator surefireValidator;
    private PluginCfgValidator failsafeValidator;
    private Properties projectProperties;
    private String initialArgLinePropertyValue;

    public PluginsHandler(MavenProject project, Logger logger) {
        this.setProject(project);
        this.setLogger(logger);
        project.getPlugin("");
        this.surefireValidator = PluginCfgValidator.createSurefireCfgValidator();
        this.failsafeValidator = PluginCfgValidator.createFailsafeCfgValidator();
        this.pluginsDiscovered = false;
        this.projectProperties = project.getProperties();
    }

    public void detectConfigurations() {
        if (this.pluginsDiscovered) {
            return;
        }
        this.lookForPlugins(this.project.getBuildPlugins());
        if (!this.bothPluginsFound() && this.project.getPluginManagement() != null) {
            this.lookForPlugins(this.project.getPluginManagement().getPlugins());
        }
        this.pluginsDiscovered = true;
        this.logger.info("Done discovery of surefire and failsafe plugins: surefire {}, failsafe {}", (Object)this.buildFoundString(this.isSurefireExists()), (Object)this.buildFoundString(this.isFailsafeExists()));
    }

    public void updateProperties(String slArgument, String token, boolean withSealights) {
        this.logger.info("Updating the properties: '{}', '{}'", (Object)slArgument, (Object)withSealights);
        this.notifyConfiguration();
        this.handleArgLineProperty(slArgument, withSealights);
        this.projectProperties.setProperty(SEALIGHTS_ARG_LINE, slArgument);
        PluginCfgLogger.logPluginSettings(this.logger, this.project.getProperties(), this.surefireValidator.getConfiguration(), this.failsafeValidator.getConfiguration(), token, withSealights);
    }

    public boolean isSurefireExists() {
        return this.surefireValidator.isPluginExists();
    }

    public boolean isFailsafeExists() {
        return this.failsafeValidator.isPluginExists();
    }

    public boolean isValidConfiguration() {
        return this.surefireValidator.isValidConfiguration() && this.failsafeValidator.isValidConfiguration();
    }

    public void notifyConfiguration() {
        StringBuilder notifMessageBuilder = new StringBuilder();
        notifMessageBuilder.append("module:").append(this.project.getName()).append(", ");
        boolean surefireNotified = this.logAndNotifyPluginConfiguration(this.surefireValidator, notifMessageBuilder, false);
        boolean failsafeNotified = this.logAndNotifyPluginConfiguration(this.failsafeValidator, notifMessageBuilder, surefireNotified);
        if (!("pom".equals(this.project.getPackaging()) || surefireNotified || failsafeNotified)) {
            BuildLifeCycle.notifyWarning("neither surefire or failsafe plugin is set, SeaLights Test Listener will not run.");
            this.logger.warn("neither surefire or failsafe plugin is set, SeaLights Test Listener will not run.");
        } else {
            BuildLifeCycle.notifyInfo(notifMessageBuilder.toString());
        }
    }

    String getSurefireArgLine() {
        return this.surefireValidator.getConfiguration().getArgLine();
    }

    String getFailsafeArgLine() {
        return this.failsafeValidator.getConfiguration().getArgLine();
    }

    private void lookForPlugins(List<Plugin> plugins) {
        Plugin surefirePlugin = null;
        Plugin failsafePlugin = null;
        Plugin jacocoPlugin = null;
        for (Plugin plugin : plugins) {
            if ("maven-surefire-plugin".equals(plugin.getArtifactId()) && !this.surefireValidator.isPluginExists()) {
                surefirePlugin = plugin;
            }
            if ("maven-failsafe-plugin".equals(plugin.getArtifactId()) && !this.failsafeValidator.isPluginExists()) {
                failsafePlugin = plugin;
            }
            if (!"jacoco-maven-plugin".equals(plugin.getArtifactId())) continue;
            jacocoPlugin = plugin;
        }
        if (jacocoPlugin != null) {
            this.jacocoPluginConfiguration = JacocoPluginHandler.parse(jacocoPlugin);
        }
        if (surefirePlugin != null) {
            this.surefireValidator.fillAndValidateConfiguration(surefirePlugin, this.jacocoPluginConfiguration);
        }
        if (failsafePlugin != null) {
            this.failsafeValidator.fillAndValidateConfiguration(failsafePlugin, this.jacocoPluginConfiguration);
        }
    }

    private boolean bothPluginsFound() {
        return this.isSurefireExists() && this.isFailsafeExists();
    }

    private boolean logAndNotifyPluginConfiguration(PluginCfgValidator validator, StringBuilder builder, boolean nextEntry) {
        if (!validator.isPluginExists()) {
            return false;
        }
        PluginCfgLogger.logValidationResults(this.logger, validator.getConfiguration().getArtifactId(), validator.getValidationResult());
        if (nextEntry) {
            builder.append(", ");
        }
        builder.append(validator.getConfiguration().toString());
        String validationResult = validator.getValidationResult().asString();
        if (validationResult != null) {
            builder.append(", validation result: ").append(validationResult);
        }
        return true;
    }

    private void handleArgLineProperty(String slArgument, boolean onSuccess) {
        String newArgLineProperty;
        Properties projectProperties = this.project.getProperties();
        this.initialArgLinePropertyValue = projectProperties.getProperty("argLine");
        this.setArgLineToEmptyIfNotInitialized(projectProperties);
        if ((onSuccess || StringUtils.isNotEmpty(this.initialArgLinePropertyValue)) && (newArgLineProperty = this.resolveNewArgLineProperty(this.initialArgLinePropertyValue, slArgument)) != null) {
            this.logger.info("argLine property set to {}", (Object)newArgLineProperty);
            projectProperties.setProperty("argLine", newArgLineProperty);
        }
    }

    private void setArgLineToEmptyIfNotInitialized(Properties projectProperties) {
        PluginConfiguration surefireValidatorConfiguration = this.surefireValidator.getConfiguration();
        PluginConfiguration failsafeValidatorConfiguration = this.failsafeValidator.getConfiguration();
        if (this.initialArgLinePropertyValue == null && (surefireValidatorConfiguration.hasArgLinePlaceholder() || failsafeValidatorConfiguration.hasArgLinePlaceholder())) {
            projectProperties.setProperty("argLine", "");
        }
    }

    private String resolveNewArgLineProperty(String origArgLine, String slArgument) {
        this.logger.info("Original <argLine> is: {} and slArgument {}", (Object)origArgLine, (Object)slArgument);
        if (this.surefireValidator.isArgLinePropertyRelevant() || this.failsafeValidator.isArgLinePropertyRelevant()) {
            String modifiedArgLine;
            if (StringUtils.isNotEmpty(origArgLine)) {
                this.logger.info("The '{}' property is already set to:'{}'", (Object)"argLine", (Object)origArgLine);
                modifiedArgLine = this.buildArgLine(origArgLine, slArgument);
            } else {
                this.logger.info("The modified <argLine>: '{}'", (Object)slArgument);
                modifiedArgLine = slArgument;
            }
            return modifiedArgLine;
        }
        if (StringUtils.isNotEmpty(origArgLine)) {
            // empty if block
        }
        this.logger.info("No <argLine> modifications will be done");
        return null;
    }

    private String buildArgLine(String origArgLine, String slArgument) {
        String unduplicatedArgline = ArgLineNormalizer.removeArgLineDuplication(origArgLine);
        this.warnForOtherJavaAgents(unduplicatedArgline);
        StringBuilder newArgLine = new StringBuilder(slArgument);
        if (!StringUtils.isNullOrEmpty(unduplicatedArgline)) {
            newArgLine.append(" ");
            newArgLine.append(unduplicatedArgline);
        }
        return newArgLine.toString();
    }

    private void warnForOtherJavaAgents(String argLineVariable) {
        if (argLineVariable != null && argLineVariable.contains(" -javaagent:")) {
            PluginCfgLogger.logImportantInfo(this.logger, "Warning", "Another java agent is running with SeaLights.", "This may interfere with the test-listener agent and cause the low code coverage.");
        }
    }

    private String buildFoundString(boolean isFound) {
        return isFound ? "found" : "not found";
    }

    @Generated
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Generated
    public PluginCfgValidator getSurefireValidator() {
        return this.surefireValidator;
    }

    @Generated
    public PluginCfgValidator getFailsafeValidator() {
        return this.failsafeValidator;
    }

    @Generated
    public Properties getProjectProperties() {
        return this.projectProperties;
    }

    static final class ArgLineNormalizer {
        static int IGNORE_WHITE_SPACES = 0;
        static int IN_QUOTES = 1;
        static int AFTER_QUOTES = 2;
        static int IN_SEQUENCE = 3;
        static int ESCAPED = 4;

        public static String removeArgLineDuplication(String oldArgLine) {
            List<String> args = ArgLineNormalizer.toArgsArray(oldArgLine);
            return ArgLineNormalizer.deleteSeaLightsLeftovers(args);
        }

        private static String deleteSeaLightsLeftovers(List<String> args) {
            Iterator<String> iterator = args.iterator();
            while (iterator.hasNext()) {
                String argument = iterator.next();
                if (!ArgLineNormalizer.isSeaLightsProperty(argument) && !ArgLineNormalizer.isSeaLightsTestListener(argument)) continue;
                iterator.remove();
            }
            String ret = StringUtils.join(args, ' ');
            return ret;
        }

        private static List<String> toArgsArray(String argsAsString) {
            ArrayList<String> args = new ArrayList<String>();
            int state = 0;
            StringBuilder currentArg = new StringBuilder();
            for (char c : argsAsString.toCharArray()) {
                if (state == IGNORE_WHITE_SPACES) {
                    if (Character.isWhitespace(c)) continue;
                    currentArg.append(c);
                    if (ArgLineNormalizer.isQuote(c)) {
                        state = IN_QUOTES;
                        continue;
                    }
                    state = IN_SEQUENCE;
                    continue;
                }
                if (state == IN_QUOTES) {
                    currentArg.append(c);
                    if (!ArgLineNormalizer.isQuote(c)) continue;
                    state = AFTER_QUOTES;
                    continue;
                }
                if (state == AFTER_QUOTES) {
                    if (!Character.isWhitespace(c)) {
                        currentArg.append(c);
                        if (ArgLineNormalizer.isQuote(c)) {
                            state = IN_QUOTES;
                            continue;
                        }
                        state = IN_SEQUENCE;
                        continue;
                    }
                    args.add(currentArg.toString());
                    currentArg.setLength(0);
                    state = IGNORE_WHITE_SPACES;
                    continue;
                }
                if (state != IN_SEQUENCE) continue;
                if (!Character.isWhitespace(c)) {
                    currentArg.append(c);
                    if (!ArgLineNormalizer.isQuote(c)) continue;
                    state = IN_QUOTES;
                    continue;
                }
                args.add(currentArg.toString());
                currentArg.setLength(0);
                state = IGNORE_WHITE_SPACES;
            }
            args.add(currentArg.toString());
            return args;
        }

        private static boolean isQuote(char ch) {
            return ch == '\"' || ch == '\'';
        }

        private static boolean isSeaLightsProperty(String argument) {
            return argument.startsWith("-Dsl.");
        }

        private static boolean isSeaLightsTestListener(String argument) {
            return argument.startsWith("-javaagent:") && ArgLineNormalizer.isValidTestListenerName(argument);
        }

        private static boolean isValidTestListenerName(String testListenerName) {
            return testListenerName != null && (testListenerName.contains(PluginsHandler.SL_TEST_LISTENER) || testListenerName.contains(PluginsHandler.JAVA_TEST_LISTENER) || testListenerName.contains(PluginsHandler.DEV_SL_TEST_LISTENER));
        }

        @Generated
        private ArgLineNormalizer() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

