/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;

public class BuildNameResolver {
    private static final Logger LOGGER = LogFactory.getLogger(BuildNameResolver.class);
    public static final String TIMESTAMP_AS_BUILDNAME_TAG = "SL_Timestamp";
    public static final String BUILDNAME_TIMESTAMP_PATTERN = "yyyy.MM.dd-HH.mm";

    public String resolveBuildName(String buildName, long millis) {
        if (TIMESTAMP_AS_BUILDNAME_TAG.equals(buildName)) {
            String timestamp = this.generateTimestamp(millis);
            LOGGER.warn("Resolved 'buildName' as timestamp '{}'", (Object)timestamp);
            return timestamp;
        }
        return buildName;
    }

    private String generateTimestamp(long millis) {
        Date date = new Date(millis);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(BUILDNAME_TIMESTAMP_PATTERN);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }
}

