/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.api;

import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import io.sealights.plugins.engine.api.BldScanrCliData;
import io.sealights.plugins.engine.api.ExecutionStage;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.ProjectDescriptor;
import io.sealights.plugins.engine.api.TstListnrCliData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class PluginExecData {
    public static final String SKIP_SEALIGHTS_MSG = "skip SEALIGHTS integration";
    private static final String EMPTY_VALUE = "empty";
    private ExecutionStage execStage = ExecutionStage.init;
    private String buildSessionId;
    private BuildSessionData buildSessionData = new BuildSessionData();
    private String token;
    private TokenData tokenData;
    private String bldScanrLocation;
    private String tstLisnrLocation;
    private ConcurrentHashMap<String, ProjectExecData> projectsExecData = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> executions = new ConcurrentHashMap();

    public synchronized void setInitState(boolean lastModule) {
        this.execStage = this.execStage.resolveInitState(lastModule);
    }

    public synchronized void setBuildEndExecStage() {
        this.execStage = ExecutionStage.init;
    }

    public synchronized void setBuildSessionId(String buildSessionId) {
        this.buildSessionId = buildSessionId;
    }

    public synchronized void setBuildSessionData(BuildSessionData buildSessionData) {
        this.buildSessionData = buildSessionData;
    }

    public synchronized void setToken(String token) {
        this.token = token;
    }

    public synchronized void setTokenData(TokenData tokenData) {
        this.tokenData = tokenData;
    }

    public synchronized void setBldScanrLocation(String bldScanrLocation) {
        this.bldScanrLocation = bldScanrLocation;
    }

    public synchronized void setTstLisnrLocation(String tstLisnrLocation) {
        this.tstLisnrLocation = tstLisnrLocation;
    }

    public synchronized void setExecStage(ExecutionStage execStage) {
        this.execStage = execStage;
    }

    public synchronized String getAppName() {
        if (this.buildSessionData != null) {
            return this.buildSessionData.getAppName();
        }
        return EMPTY_VALUE;
    }

    public boolean hasExecution(String testStage) {
        if (testStage != null) {
            return this.executions.containsKey(testStage);
        }
        return false;
    }

    public String getExecution(String testStage) {
        if (testStage != null) {
            return this.executions.get(testStage);
        }
        return null;
    }

    public void addExecution(String testStage, String executionId) {
        if (testStage != null && executionId != null) {
            this.executions.put(testStage, executionId);
        }
    }

    public synchronized boolean isBuildScannerInvoked() {
        for (String projectName : this.projectsExecData.keySet()) {
            if (!this.isScannedProject(projectName)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isScannedProject(String projectName) {
        return this.getProjectData(projectName).getScanResult() != null;
    }

    public synchronized void setPorjectScanResult(String projectName, boolean scanResult) {
        if (StringUtils.isNotEmpty(projectName)) {
            this.getProjectData(projectName).setScanResult(scanResult);
        }
    }

    public synchronized void initProjectDescriptor(String projectName, PluginGoal goal) {
        if (this.getProjectDescriptor(projectName) == null) {
            this.getProjectData(projectName).setProjectDescriptor(goal.getProjectDescriptor());
        }
    }

    public synchronized void setProjectDescriptor(ProjectDescriptor projectDescriptor) {
        this.getProjectData(projectDescriptor.getProjectName()).setProjectDescriptor(projectDescriptor);
    }

    public synchronized ProjectDescriptor getProjectDescriptor(String projectName) {
        return this.getProjectData(projectName).getProjectDescriptor();
    }

    public synchronized BldScanrCliData getBldScanrCliData(String projectName) {
        return this.getProjectData(projectName).getBldScanrCliData();
    }

    public synchronized void setBldScanrCliData(String projectName, BldScanrCliData bldScanrCliData) {
        this.getProjectData(projectName).setBldScanrCliData(bldScanrCliData);
    }

    public synchronized TstListnrCliData getTstLisnrCliData(String projectName) {
        return this.getProjectData(projectName).getTstLisnrCliData();
    }

    public synchronized void setTstLisnrCliData(String projectName, TstListnrCliData tstLisnrCliData) {
        this.getProjectData(projectName).setTstLisnrCliData(tstLisnrCliData);
    }

    public synchronized void setProjectMetaDataFilePath(String projectName, String metaDataFilePath) {
        this.getProjectData(projectName).setMetaDataFilePath(metaDataFilePath);
    }

    public synchronized String getProjectMetaDataFilePath(String projectName) {
        return this.getProjectData(projectName).getMetaDataFilePath();
    }

    public synchronized List<String> getProjectsMetaDataFiles() {
        ArrayList<String> metaDataFileNames = new ArrayList<String>();
        for (ProjectExecData execData : this.projectsExecData.values()) {
            metaDataFileNames.add(execData.getMetaDataFilePath());
        }
        return metaDataFileNames;
    }

    public String getCustomerId() {
        return this.tokenData != null ? this.tokenData.getCustomerId() : null;
    }

    public String getServer() {
        return this.tokenData != null ? this.tokenData.getServer() : "";
    }

    public String toString() {
        return String.format("(execStage=%s, bldScanrLocation=%s, tstLisnrLocation=%s, token(size)=%s, %s, buildSessionId=%s, %s, executions=%s, projectsExecData=%s)", new Object[]{this.execStage, this.bldScanrLocation, this.tstLisnrLocation, this.token.length(), this.tokenData, this.buildSessionId, this.buildSessionData, this.executions, ToStringFormatter.toString(this.projectsExecData)});
    }

    private ProjectExecData getProjectData(String projectName) {
        if (!this.projectsExecData.containsKey(projectName)) {
            this.projectsExecData.put(projectName, new ProjectExecData());
        }
        return this.projectsExecData.get(projectName);
    }

    @Generated
    public ExecutionStage getExecStage() {
        return this.execStage;
    }

    @Generated
    public String getBuildSessionId() {
        return this.buildSessionId;
    }

    @Generated
    public BuildSessionData getBuildSessionData() {
        return this.buildSessionData;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public TokenData getTokenData() {
        return this.tokenData;
    }

    @Generated
    public String getBldScanrLocation() {
        return this.bldScanrLocation;
    }

    @Generated
    public String getTstLisnrLocation() {
        return this.tstLisnrLocation;
    }

    @Generated
    public ConcurrentHashMap<String, ProjectExecData> getProjectsExecData() {
        return this.projectsExecData;
    }

    @Generated
    public ConcurrentHashMap<String, String> getExecutions() {
        return this.executions;
    }

    static class ProjectExecData {
        private ProjectDescriptor projectDescriptor;
        private TstListnrCliData tstLisnrCliData;
        private BldScanrCliData bldScanrCliData;
        private String metaDataFilePath;
        private Boolean scanResult;

        public String toString() {
            return String.format("tstLisnrCliData=%s, bldScanrCliData=%s, metaDataFilePath=%s, projectDescriptor=%s", this.tstLisnrCliData, this.bldScanrCliData, this.metaDataFilePath, this.projectDescriptor);
        }

        @Generated
        public ProjectExecData() {
        }

        @Generated
        public ProjectDescriptor getProjectDescriptor() {
            return this.projectDescriptor;
        }

        @Generated
        public TstListnrCliData getTstLisnrCliData() {
            return this.tstLisnrCliData;
        }

        @Generated
        public BldScanrCliData getBldScanrCliData() {
            return this.bldScanrCliData;
        }

        @Generated
        public String getMetaDataFilePath() {
            return this.metaDataFilePath;
        }

        @Generated
        public Boolean getScanResult() {
            return this.scanResult;
        }

        @Generated
        public void setProjectDescriptor(ProjectDescriptor projectDescriptor) {
            this.projectDescriptor = projectDescriptor;
        }

        @Generated
        public void setTstLisnrCliData(TstListnrCliData tstLisnrCliData) {
            this.tstLisnrCliData = tstLisnrCliData;
        }

        @Generated
        public void setBldScanrCliData(BldScanrCliData bldScanrCliData) {
            this.bldScanrCliData = bldScanrCliData;
        }

        @Generated
        public void setMetaDataFilePath(String metaDataFilePath) {
            this.metaDataFilePath = metaDataFilePath;
        }

        @Generated
        public void setScanResult(Boolean scanResult) {
            this.scanResult = scanResult;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectExecData)) {
                return false;
            }
            ProjectExecData other = (ProjectExecData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$scanResult = this.getScanResult();
            Boolean other$scanResult = other.getScanResult();
            if (this$scanResult == null ? other$scanResult != null : !((Object)this$scanResult).equals(other$scanResult)) {
                return false;
            }
            ProjectDescriptor this$projectDescriptor = this.getProjectDescriptor();
            ProjectDescriptor other$projectDescriptor = other.getProjectDescriptor();
            if (this$projectDescriptor == null ? other$projectDescriptor != null : !((Object)this$projectDescriptor).equals(other$projectDescriptor)) {
                return false;
            }
            TstListnrCliData this$tstLisnrCliData = this.getTstLisnrCliData();
            TstListnrCliData other$tstLisnrCliData = other.getTstLisnrCliData();
            if (this$tstLisnrCliData == null ? other$tstLisnrCliData != null : !((Object)this$tstLisnrCliData).equals(other$tstLisnrCliData)) {
                return false;
            }
            BldScanrCliData this$bldScanrCliData = this.getBldScanrCliData();
            BldScanrCliData other$bldScanrCliData = other.getBldScanrCliData();
            if (this$bldScanrCliData == null ? other$bldScanrCliData != null : !((Object)this$bldScanrCliData).equals(other$bldScanrCliData)) {
                return false;
            }
            String this$metaDataFilePath = this.getMetaDataFilePath();
            String other$metaDataFilePath = other.getMetaDataFilePath();
            return !(this$metaDataFilePath == null ? other$metaDataFilePath != null : !this$metaDataFilePath.equals(other$metaDataFilePath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProjectExecData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $scanResult = this.getScanResult();
            result = result * 59 + ($scanResult == null ? 43 : ((Object)$scanResult).hashCode());
            ProjectDescriptor $projectDescriptor = this.getProjectDescriptor();
            result = result * 59 + ($projectDescriptor == null ? 43 : ((Object)$projectDescriptor).hashCode());
            TstListnrCliData $tstLisnrCliData = this.getTstLisnrCliData();
            result = result * 59 + ($tstLisnrCliData == null ? 43 : ((Object)$tstLisnrCliData).hashCode());
            BldScanrCliData $bldScanrCliData = this.getBldScanrCliData();
            result = result * 59 + ($bldScanrCliData == null ? 43 : ((Object)$bldScanrCliData).hashCode());
            String $metaDataFilePath = this.getMetaDataFilePath();
            result = result * 59 + ($metaDataFilePath == null ? 43 : $metaDataFilePath.hashCode());
            return result;
        }
    }
}

