/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class PluginExecResult {
    private boolean ok;
    private List<String> errorMsgs = new ArrayList<String>();

    public PluginExecResult() {
        this.setOk();
    }

    public void setOk() {
        this.setOk(true);
    }

    public void setFailure() {
        this.setOk(false);
    }

    public void setFailure(List<String> errorMsgs) {
        this.setFailure();
        this.errorMsgs.addAll(errorMsgs);
    }

    public void setFailure(String msg) {
        this.setFailure();
        this.errorMsgs.add(msg);
    }

    public void setFailure(String msg, Exception err) {
        this.setFailure(String.format("%s, error:'%s'", msg, err.toString()));
    }

    public void setFailure(String msg, Throwable err) {
        this.setFailure(String.format("%s, error:'%s'", msg, err.toString()));
    }

    private String toStringStatus() {
        return this.ok ? "success" : "failure";
    }

    private String toStringErrors() {
        StringBuilder buf = new StringBuilder();
        for (String err : this.errorMsgs) {
            buf.append(String.format("[%s];", err));
        }
        return buf.toString();
    }

    public String toString() {
        return String.format("GeneralOpResult (%s, errors: %s)", this.toStringStatus(), this.toStringErrors());
    }

    @Generated
    public boolean isOk() {
        return this.ok;
    }

    @Generated
    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    @Generated
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Generated
    public void setErrorMsgs(List<String> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginExecResult)) {
            return false;
        }
        PluginExecResult other = (PluginExecResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        List<String> this$errorMsgs = this.getErrorMsgs();
        List<String> other$errorMsgs = other.getErrorMsgs();
        return !(this$errorMsgs == null ? other$errorMsgs != null : !((Object)this$errorMsgs).equals(other$errorMsgs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginExecResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        List<String> $errorMsgs = this.getErrorMsgs();
        result = result * 59 + ($errorMsgs == null ? 43 : ((Object)$errorMsgs).hashCode());
        return result;
    }
}

