/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.api;

import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import io.sealights.plugins.engine.api.DependencyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;

public class ProjectDescriptor {
    public static final String TESTNG_GROUP = "org.testng";
    public static final String TESTNG_ARTIFACT = "testng";
    private String pluginName = "";
    private String pluginVersion = "";
    private String projectName = "";
    private String version = "";
    private Properties properties;
    private String buildSourceDirectory = "";
    private String baseDirectory = "";
    private String buildOutputDirectory = "";
    private List<DependencyInfo> dependencies;
    private List<DependencyInfo> plugins;

    public ProjectDescriptor() {
        this.properties = new Properties();
        this.dependencies = new ArrayList<DependencyInfo>();
        this.plugins = new ArrayList<DependencyInfo>();
    }

    public ProjectDescriptor(String projectName) {
        this();
        this.projectName = projectName;
    }

    public Map<String, Object> asKeyValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pluginName", this.pluginName);
        map.put("pluginVersion", this.pluginVersion);
        map.put("projectName", this.projectName);
        map.put("version", this.version);
        map.put("properties", this.properties);
        map.put("buildSourceDirectory", this.buildSourceDirectory);
        map.put("baseDirectory", this.baseDirectory);
        map.put("buildOutputDirectory", this.buildOutputDirectory);
        map.put("dependencies", this.dependencies);
        map.put("plugins", this.plugins);
        return map;
    }

    public DependencyInfo getTestNgDependencyInfo() {
        if (this.dependencies != null) {
            for (DependencyInfo depInfo : this.dependencies) {
                if (!TESTNG_GROUP.equals(depInfo.getGroupID()) || !TESTNG_ARTIFACT.equals(depInfo.getArtifactID())) continue;
                return depInfo;
            }
        }
        return null;
    }

    public String toString() {
        return String.format("ProjectDescriptor (pluginName=%s, pluginVersion=%s, projectName=%s, version=%s, buildSourceDirectory=%s, baseDirectory=%s, buildOutputDirectory=%s, %nproperties:%s%ndependencies:%s%nplugins:%s)", this.pluginName, this.pluginVersion, this.projectName, this.version, this.buildSourceDirectory, this.baseDirectory, this.buildOutputDirectory, ToStringFormatter.toString(this.properties), ToStringFormatter.toString(this.dependencies), ToStringFormatter.toString(this.plugins));
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    @Generated
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public String getBuildSourceDirectory() {
        return this.buildSourceDirectory;
    }

    @Generated
    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    @Generated
    public String getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    @Generated
    public List<DependencyInfo> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public List<DependencyInfo> getPlugins() {
        return this.plugins;
    }

    @Generated
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Generated
    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Generated
    public void setBuildSourceDirectory(String buildSourceDirectory) {
        this.buildSourceDirectory = buildSourceDirectory;
    }

    @Generated
    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Generated
    public void setBuildOutputDirectory(String buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    @Generated
    public void setDependencies(List<DependencyInfo> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public void setPlugins(List<DependencyInfo> plugins) {
        this.plugins = plugins;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectDescriptor)) {
            return false;
        }
        ProjectDescriptor other = (ProjectDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pluginName = this.getPluginName();
        String other$pluginName = other.getPluginName();
        if (this$pluginName == null ? other$pluginName != null : !this$pluginName.equals(other$pluginName)) {
            return false;
        }
        String this$pluginVersion = this.getPluginVersion();
        String other$pluginVersion = other.getPluginVersion();
        if (this$pluginVersion == null ? other$pluginVersion != null : !this$pluginVersion.equals(other$pluginVersion)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$buildSourceDirectory = this.getBuildSourceDirectory();
        String other$buildSourceDirectory = other.getBuildSourceDirectory();
        if (this$buildSourceDirectory == null ? other$buildSourceDirectory != null : !this$buildSourceDirectory.equals(other$buildSourceDirectory)) {
            return false;
        }
        String this$baseDirectory = this.getBaseDirectory();
        String other$baseDirectory = other.getBaseDirectory();
        if (this$baseDirectory == null ? other$baseDirectory != null : !this$baseDirectory.equals(other$baseDirectory)) {
            return false;
        }
        String this$buildOutputDirectory = this.getBuildOutputDirectory();
        String other$buildOutputDirectory = other.getBuildOutputDirectory();
        if (this$buildOutputDirectory == null ? other$buildOutputDirectory != null : !this$buildOutputDirectory.equals(other$buildOutputDirectory)) {
            return false;
        }
        List<DependencyInfo> this$dependencies = this.getDependencies();
        List<DependencyInfo> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<DependencyInfo> this$plugins = this.getPlugins();
        List<DependencyInfo> other$plugins = other.getPlugins();
        return !(this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjectDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginName = this.getPluginName();
        result = result * 59 + ($pluginName == null ? 43 : $pluginName.hashCode());
        String $pluginVersion = this.getPluginVersion();
        result = result * 59 + ($pluginVersion == null ? 43 : $pluginVersion.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $buildSourceDirectory = this.getBuildSourceDirectory();
        result = result * 59 + ($buildSourceDirectory == null ? 43 : $buildSourceDirectory.hashCode());
        String $baseDirectory = this.getBaseDirectory();
        result = result * 59 + ($baseDirectory == null ? 43 : $baseDirectory.hashCode());
        String $buildOutputDirectory = this.getBuildOutputDirectory();
        result = result * 59 + ($buildOutputDirectory == null ? 43 : $buildOutputDirectory.hashCode());
        List<DependencyInfo> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<DependencyInfo> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        return result;
    }

    @Generated
    public ProjectDescriptor(String pluginName, String pluginVersion, String projectName, String version, Properties properties, String buildSourceDirectory, String baseDirectory, String buildOutputDirectory, List<DependencyInfo> dependencies, List<DependencyInfo> plugins) {
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.projectName = projectName;
        this.version = version;
        this.properties = properties;
        this.buildSourceDirectory = buildSourceDirectory;
        this.baseDirectory = baseDirectory;
        this.buildOutputDirectory = buildOutputDirectory;
        this.dependencies = dependencies;
        this.plugins = plugins;
    }
}

