/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.clibuilders;

import io.sealights.onpremise.agents.infra.constants.SLProperties;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginParameters;
import io.sealights.plugins.engine.api.PluginType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public abstract class AgentCliBuilder {
    private PluginExecData execData;
    private PluginGoal goal;
    private List<String> destArgs = new ArrayList<String>();
    private Map<String, String> sysPropertiesBuffer = new HashMap<String, String>();

    public AgentCliBuilder(PluginGoal goal, PluginExecData execData) {
        this.goal = goal;
        this.execData = execData;
    }

    public AgentCliBuilder execute() {
        this.putAgrsBeforeSysProperties();
        this.putSysProperties();
        this.finalizeSysPropertiesHandling();
        this.putArgsAfterSysProperties();
        this.printArgsToLog();
        return this;
    }

    public List<String> asArgsArray() {
        return this.destArgs;
    }

    public String asString() {
        StringBuilder buf = new StringBuilder();
        for (String a : this.destArgs) {
            buf.append(a).append(" ");
        }
        return buf.toString();
    }

    public void printArgsToLog() {
        this.goal.getLogger().info("------------SeaLights agent CLI arguments------------");
        boolean prevArgWasToken = false;
        for (String s : this.destArgs) {
            if (prevArgWasToken) {
                s = TokenValueFormatter.truncateTokenArgValue(s);
                prevArgWasToken = false;
            }
            if (s.contains("sl.token")) {
                s = TokenValueFormatter.truncateTokenSysProperty(s, this.getToken());
            }
            this.goal.getLogger().info(s);
            if (!s.equals("-token")) continue;
            prevArgWasToken = true;
        }
        this.goal.getLogger().info("------------SeaLights agent CLI arguments------------");
    }

    protected PluginParameters getGoalParams() {
        return this.goal.getParams();
    }

    protected boolean isGradlePlugin() {
        return this.getGoal().getPluginType() == PluginType.gradle;
    }

    protected boolean isMavenPlugin() {
        return this.getGoal().getPluginType() == PluginType.maven;
    }

    protected void putJavaArg() {
        if (this.getJavaPath() != null) {
            this.destArgs.add(this.getJavaPath());
        }
    }

    protected void putLogProperties() {
        if (this.isLogDisabled()) {
            return;
        }
        boolean logsActive = false;
        if (this.isLogToConsole()) {
            logsActive = true;
            this.putSysProperty("sl.log.toConsole", true);
        }
        if (this.isLogToFile()) {
            logsActive = true;
            this.putSysProperty("sl.log.toFile", true);
            this.putSysPropertyInQuotes("sl.log.filename", this.getLogFileName());
            if (StringUtils.isNotEmpty(this.getGoalParams().getGeneralParams().getLogFolder())) {
                String dir = PathUtils.join(this.getGoalParams().getGeneralParams().getLogFolder(), this.getLogFolderName());
                this.putSysPropertyInQuotes("sl.log.folder", dir);
            }
        }
        if (logsActive) {
            this.setBackwardCompatibleProperties();
        }
    }

    protected void setBackwardCompatibleProperties() {
        this.putSysProperty("sl.log.enabled", true);
        if (StringUtils.isNotEmpty(this.getGoalParams().getGeneralParams().getLogLevel())) {
            this.putSysProperty("sl.log.level", this.getGoalParams().getGeneralParams().getLogLevel());
        } else {
            this.putSysProperty("sl.log.level", Level.INFO.getName());
        }
    }

    protected void putSealightsJvmParam(boolean inQuotesStrValue) {
        this.putJvmParamsAsSysProps(this.getSealightsJvmParams(), inQuotesStrValue);
    }

    protected void putJvmParamsAsSysProps(Map<String, ?> jvmParams, boolean inQuotesStrValue) {
        if (jvmParams != null) {
            for (Map.Entry<String, ?> entry : jvmParams.entrySet()) {
                if (entry.getValue() == null) continue;
                String propValue = inQuotesStrValue ? this.inQuotes(entry.getValue()) : String.valueOf(entry.getValue());
                this.putSysProperty(entry.getKey(), propValue);
            }
        }
    }

    protected String inQuotes(Object value) {
        String tmp = value.toString().toLowerCase();
        if ("true".equals(tmp) || "false".equals(tmp)) {
            return value.toString();
        }
        return StringUtils.inSingleQuotes(value.toString());
    }

    protected String withDash(String argName) {
        return "-" + argName;
    }

    protected void putArgument(String argName) {
        this.destArgs.add(this.withDash(argName));
        if (this.isGradlePlugin()) {
            this.putGradleArgument(argName);
        }
    }

    protected boolean putArgument(String argName, String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.destArgs.add(this.withDash(argName));
            this.destArgs.add(value);
            if (this.isGradlePlugin()) {
                this.putGradleArgument(argName, value);
            }
            return true;
        }
        return false;
    }

    protected boolean putSysPropertyInQuotes(String propertyName, String propertyValue) {
        return this.putSysProperty(propertyName, StringUtils.inSingleQuotes(propertyValue));
    }

    protected boolean putSysProperty(String propertyName, String propertyValue) {
        if (StringUtils.isNotEmpty(propertyValue)) {
            this.sysPropertiesBuffer.put(propertyName, propertyValue);
            return true;
        }
        return false;
    }

    protected void putSysProperty(String propertyName, boolean propertyValue) {
        this.sysPropertiesBuffer.put(propertyName, Boolean.toString(propertyValue));
    }

    protected void readAndPutBoolSysProperty(String propertyName) {
        String rawValue = System.getProperty(propertyName);
        if (StringUtils.isNotEmpty(rawValue)) {
            boolean boolValue = Boolean.valueOf(rawValue);
            this.putSysProperty(propertyName, boolValue);
        }
    }

    protected void finalizeSysPropertiesHandling() {
        for (Map.Entry<String, String> entry : this.sysPropertiesBuffer.entrySet()) {
            this.destArgs.add(SLProperties.toJvmAgr(entry.getKey(), entry.getValue()));
        }
        if (this.isGradlePlugin()) {
            this.getGradlePluginSysProps().putAll(this.sysPropertiesBuffer);
        }
    }

    protected abstract void putAgrsBeforeSysProperties();

    protected abstract void putSysProperties();

    protected abstract void putArgsAfterSysProperties();

    protected abstract String getLogFileName();

    protected abstract String getLogFolderName();

    protected abstract Map<String, String> getGradlePluginSysProps();

    protected abstract void putGradleArgument(String var1);

    protected abstract void putGradleArgument(String var1, String var2);

    protected abstract boolean isLogDisabled();

    public String getToken() {
        return this.execData.getToken();
    }

    public String getBuildSessionId() {
        return this.execData.getBuildSessionId();
    }

    public String getProjectVersion() {
        return this.execData.getProjectDescriptor(this.getModuleName()).getVersion();
    }

    public String getModuleName() {
        return this.getGoal().getModuleName();
    }

    public String getPathToMetaJson() {
        return this.execData.getProjectMetaDataFilePath(this.getModuleName());
    }

    public String getBldScanrLocation() {
        return this.execData.getBldScanrLocation();
    }

    public String getTstLisnrLocation() {
        return this.execData.getTstLisnrLocation();
    }

    public String getExecutionId() {
        return this.execData.getExecution(this.getTestStage());
    }

    public String getCustomerid() {
        return this.execData.getCustomerId();
    }

    public String getServer() {
        return this.execData.getServer();
    }

    public String getAppName() {
        return this.execData.getAppName();
    }

    public String getBranch() {
        return this.hasBSData() ? this.execData.getBuildSessionData().getBranchName() : null;
    }

    public String getBuild() {
        return this.hasBSData() ? this.execData.getBuildSessionData().getBuildName() : null;
    }

    public String getPackagesincluded() {
        return this.hasAdditionalParams() ? this.execData.getBuildSessionData().getAdditionalParams().getPackagesIncluded() : null;
    }

    public String getPackagesexcluded() {
        return this.hasAdditionalParams() ? this.execData.getBuildSessionData().getAdditionalParams().getPackagesExcluded() : null;
    }

    private boolean hasBSData() {
        return this.execData.getBuildSessionData() != null;
    }

    private boolean hasAdditionalParams() {
        return this.hasBSData() && this.execData.getBuildSessionData().getAdditionalParams() != null;
    }

    public String getProxy() {
        return this.getGoalParams().getGeneralParams().getProxy();
    }

    public String getWorkspacepath() {
        return this.getGoalParams().getGeneralParams().getWorkspacepath();
    }

    public String getEnvironment() {
        return this.getGoalParams().getGeneralParams().getEnvironment();
    }

    public String getFilesincluded() {
        return this.getGoalParams().getGeneralParams().getFilesincluded();
    }

    public String getFilesexcluded() {
        return this.getGoalParams().getGeneralParams().getFilesexcluded();
    }

    public boolean isRecursive() {
        return this.getGoalParams().getGeneralParams().isRecursive();
    }

    public String getLogLevel() {
        return this.getGoalParams().getGeneralParams().getLogLevel();
    }

    public boolean isLogToFile() {
        return this.getGoalParams().getGeneralParams().isLogToFile();
    }

    public boolean isLogToConsole() {
        return this.getGoalParams().getGeneralParams().isLogToConsole();
    }

    public String getLogFolder() {
        return this.getGoalParams().getGeneralParams().getLogFolder();
    }

    public String getJavaPath() {
        return this.getGoalParams().getGeneralParams().getJavaPath();
    }

    public String getFilesStorage() {
        return this.getGoalParams().getGeneralParams().getFilesStorage();
    }

    public Map<String, ?> getSealightsJvmParams() {
        return this.getGoalParams().getGeneralParams().getSealightsJvmParams();
    }

    public String getOverrideMetaJsonPath() {
        return this.getGoalParams().getGeneralParams().getOverrideMetaJsonPath();
    }

    public boolean isIncludeResources() {
        return this.getGoalParams().getGeneralParams().isIncludeResources();
    }

    public boolean isIncludeTokenResource() {
        return this.getGoalParams().getGeneralParams().isIncludeTokenResource();
    }

    public String getTestStage() {
        return this.getGoalParams().getGeneralParams().getTestStage();
    }

    public String getLabId() {
        return this.getGoalParams().getGeneralParams().getLabId();
    }

    public String getBuildScannerJar() {
        return this.getGoalParams().getGeneralParams().getBuildScannerJar();
    }

    public boolean isEnableNoneZeroErrorCode() {
        return this.getGoalParams().getBldScanrParams().isEnableNoneZeroErrorCode();
    }

    public String getBuildScannerPackagesincluded() {
        return this.getGoalParams().getBldScanrParams().getBuildScannerPackagesincluded();
    }

    public String getBuildScannerPackagesexcluded() {
        return this.getGoalParams().getBldScanrParams().getBuildScannerPackagesexcluded();
    }

    public Map<String, ?> getBuildScannerParams() {
        return this.getGoalParams().getBldScanrParams().getBuildScannerParams();
    }

    public boolean isTestListenerEnabled() {
        return this.getGoalParams().getTstListnrParams().isTestListenerEnabled();
    }

    public String getTestListenerJar() {
        return this.getGoalParams().getGeneralParams().getTestListenerJar();
    }

    public String getTestListenerConfigFile() {
        return this.getGoalParams().getTstListnrParams().getTestListenerConfigFile();
    }

    public Map<String, ?> getTestListenerJvmParams() {
        return this.getGoalParams().getTstListnrParams().getTestListenerJvmParams();
    }

    public String getClassLoadersExcluded() {
        return this.getGoalParams().getTstListnrParams().getClassLoadersExcluded();
    }

    @Generated
    public PluginExecData getExecData() {
        return this.execData;
    }

    @Generated
    public void setExecData(PluginExecData execData) {
        this.execData = execData;
    }

    @Generated
    public PluginGoal getGoal() {
        return this.goal;
    }

    @Generated
    public List<String> getDestArgs() {
        return this.destArgs;
    }

    @Generated
    public Map<String, String> getSysPropertiesBuffer() {
        return this.sysPropertiesBuffer;
    }

    @Generated
    public void setSysPropertiesBuffer(Map<String, String> sysPropertiesBuffer) {
        this.sysPropertiesBuffer = sysPropertiesBuffer;
    }
}

