/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.clibuilders;

import io.sealights.plugins.engine.api.BldScanrCliData;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.clibuilders.AgentCliBuilder;
import java.util.Map;

public class BldScanrArgsBuilder
extends AgentCliBuilder {
    private BldScanrCliData cliData = new BldScanrCliData();

    public BldScanrArgsBuilder(PluginGoal goal, PluginExecData execData) {
        super(goal, execData);
    }

    public BldScanrCliData executeAsCliData() {
        this.execute();
        return this.cliData;
    }

    @Override
    protected void putAgrsBeforeSysProperties() {
        if (this.isMavenPlugin()) {
            this.putJavaArg();
        }
    }

    @Override
    protected void putSysProperties() {
        this.putLogProperties();
        this.putSealightsJvmParam(false);
        this.readAndPutBoolSysProperty("sl.featuresData.enableLineCoverage");
        this.readAndPutBoolSysProperty("sl.featuresData.enableResolvingWithoutHash");
        this.readAndPutBoolSysProperty("sl.featuresData.ignoreMethodsWithoutLineNumbers");
        this.readAndPutBoolSysProperty("sl.featuresData.reportOnConstructors");
        this.readAndPutBoolSysProperty("sl.featuresData.reportOnGettersAndSetters");
        this.putSysProperty("sl.enableUpgrade", false);
        this.putSysProperty("sl.executedByPlugin", true);
    }

    @Override
    protected void putArgsAfterSysProperties() {
        if (this.isMavenPlugin()) {
            this.putArgument("jar", this.getBldScanrLocation());
        }
        this.putJarArgs();
    }

    @Override
    protected String getLogFileName() {
        return "build-scanner";
    }

    @Override
    protected String getLogFolderName() {
        return "scanner";
    }

    @Override
    protected Map<String, String> getGradlePluginSysProps() {
        return this.cliData.getGradlePluginSysProps();
    }

    @Override
    protected void putGradleArgument(String argName) {
        this.cliData.getGradlePluginJvmArg().add(this.withDash(argName));
    }

    @Override
    protected void putGradleArgument(String argName, String value) {
        this.cliData.getGradlePluginJvmArg().add(this.withDash(argName));
        this.cliData.getGradlePluginJvmArg().add(value);
    }

    @Override
    protected boolean isLogDisabled() {
        return !this.getGoalParams().getGeneralParams().isLogEnabled() || this.getGoalParams().getBldScanrParams().isBuildScannerIgnoreLogEnabled();
    }

    private void putJarArgs() {
        this.putArgument("scan");
        this.putArgument("token", this.getToken());
        this.putBuildSessionArgs();
        this.putArgument("proxy", this.getProxy());
        this.putArgument("workspacepath", this.getWorkspacepath());
        this.putArgument("moduleName", this.getModuleName());
        this.putArgument("filesincluded", this.getFilesincluded());
        this.putArgument("filesexcluded", this.getFilesexcluded());
        this.putArgument("pathToMetaJson", this.getPathToMetaJson());
        Map<String, ?> explisitParams = this.getBuildScannerParams();
        if (explisitParams != null && !explisitParams.isEmpty()) {
            for (Map.Entry<String, ?> entry : explisitParams.entrySet()) {
                this.putArgument(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (this.isRecursive()) {
            this.putArgument("recursive");
        }
        if (this.isEnableNoneZeroErrorCode()) {
            this.putArgument("enableNoneZeroErrorCode");
        }
    }

    private void putBuildSessionArgs() {
        this.putArgument("buildsessionid", this.getBuildSessionId());
        this.putArgument("appname", this.getAppName());
        this.putArgument("branch", this.getBranch());
        this.putArgument("build", this.getBuild());
        this.putArgument("packagesincluded", this.getPackagesincluded());
        this.putArgument("packagesexcluded", this.getPackagesexcluded());
    }
}

