/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.clibuilders;

import io.sealights.onpremise.agents.infra.configuration.SLPropertiesFilter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.DependencyInfo;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginType;
import io.sealights.plugins.engine.api.TstListnrCliData;
import io.sealights.plugins.engine.clibuilders.AgentCliBuilder;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class TstListnrCliBuilder
extends AgentCliBuilder {
    private static final String TESTNG_VERSION_6_9_13 = "6.9.13";
    private TstListnrCliData cliData = new TstListnrCliData();

    public TstListnrCliBuilder(PluginGoal goal, PluginExecData execData) {
        super(goal, execData);
    }

    public TstListnrCliData executeAsCliData() {
        this.execute();
        if (this.isMavenPlugin()) {
            this.cliData.setMavenPluginTstLisnrCli(this.asString());
        }
        return this.cliData;
    }

    @Override
    protected String getLogFileName() {
        return "test-listener";
    }

    @Override
    protected String getLogFolderName() {
        return "listener";
    }

    @Override
    protected Map<String, String> getGradlePluginSysProps() {
        return this.cliData.getGradlePluginSysProps();
    }

    @Override
    protected void putAgrsBeforeSysProperties() {
    }

    @Override
    protected void putSysProperties() {
        this.putSysPropertyInQuotes("sl.token", this.getToken());
        this.putBuildSessionProps();
        this.putLogProperties();
        this.putSysPropertyInQuotes("sl.pathToMetaJson", this.getPathToMetaJson());
        this.putSysPropertyInQuotes("sl.config.file", this.getTestListenerConfigFile());
        this.putSysProperty("sl.enabled", this.isTestListenerEnabled());
        this.putSysPropertyInQuotes("sl.proxy", this.getProxy());
        this.putSysPropertyInQuotes("sl.moduleName", this.getModuleName());
        this.putSysPropertyInQuotes("sl.environmentName", this.getEnvironment());
        this.putSysPropertyInQuotes("sl.testStage", this.getTestStage());
        this.putSysPropertyInQuotes("sl.labId", this.getLabId());
        this.putSysPropertyInQuotes("sl.classLoadersExcluded", this.getClassLoadersExcluded());
        this.putSysPropertyInQuotes("sl.fileStorage", this.getFilesStorage());
        this.putSysPropertyInQuotes("sl.testExecutionId", this.getExecutionId());
        this.putSysPropertyInQuotes("sl.testExecutionIdStage", this.getTestStage());
        this.putSysProperty("sl.executedByPlugin", true);
        this.putSysProperty("sl.enableUpgrade", false);
        this.putSysProperty("sl.anonymousExecution", false);
        if (null != this.getSealightsJvmParams()) {
            this.putSealightsJvmParam(this.isMavenPlugin());
        }
        if (null != this.getTestListenerJvmParams()) {
            this.putJvmParamsAsSysProps(this.getTestListenerJvmParams(), true);
        }
        this.putGradleTestNgArg();
        this.putFeaturesProps();
    }

    @Override
    protected void putArgsAfterSysProperties() {
        this.putJvmAgentArg();
    }

    @Override
    protected boolean putSysPropertyInQuotes(String propertyName, String propertyValue) {
        switch (this.getGoal().getPluginType()) {
            case maven: {
                return super.putSysPropertyInQuotes(propertyName, propertyValue);
            }
            case gradle: {
                return this.putSysProperty(propertyName, propertyValue);
            }
        }
        return false;
    }

    @Override
    protected void putGradleArgument(String argName) {
    }

    @Override
    protected void putGradleArgument(String argName, String value) {
    }

    @Override
    protected boolean isLogDisabled() {
        return !this.getGoalParams().getGeneralParams().isLogEnabled() || this.getGoalParams().getTstListnrParams().isTestListenerIgnoreLogEnabled();
    }

    private void putBuildSessionProps() {
        this.putSysPropertyInQuotes("sl.buildSessionId", this.getBuildSessionId());
        this.putSysPropertyInQuotes("sl.appName", this.getAppName());
        this.putSysPropertyInQuotes("sl.buildName", this.getBuild());
        this.putSysPropertyInQuotes("sl.branchName", this.getBranch());
        this.putSysPropertyInQuotes("sl.includes", this.getPackagesincluded());
        this.putSysPropertyInQuotes("sl.excludes", this.getPackagesexcluded());
    }

    private void putFeaturesProps() {
        Properties featuresProps = SLPropertiesFilter.getFeaturesProps();
        for (String key : featuresProps.stringPropertyNames()) {
            String value = featuresProps.getProperty(key);
            if (value == null) continue;
            this.putSysPropertyInQuotes(key, value);
        }
    }

    private void putJvmAgentArg() {
        String javAgentArg = null;
        switch (this.getGoal().getPluginType()) {
            case maven: {
                javAgentArg = "javaagent:" + StringUtils.inSingleQuotes(this.getTstLisnrLocation());
                break;
            }
            case gradle: {
                javAgentArg = "javaagent:" + this.getTstLisnrLocation();
                this.cliData.setGradlePluginJavaAgentArg("-" + javAgentArg);
            }
        }
        this.putArgument(javAgentArg);
    }

    private void putGradleTestNgArg() {
        ComparableVersion current;
        DependencyInfo testNgDepInfo;
        if (PluginType.gradle == this.getGoal().getPluginType() && (testNgDepInfo = this.getExecData().getProjectDescriptor(this.getModuleName()).getTestNgDependencyInfo()) != null && (current = new ComparableVersion(testNgDepInfo.getVersion())).compareTo(new ComparableVersion(TESTNG_VERSION_6_9_13)) < 0) {
            this.putSysProperty("sl.gradleTestngBefore.6.9.13", true);
        }
    }
}

