/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.lifecycle;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginType;
import io.sealights.plugins.engine.lifecycle.BuildEndInfo;
import io.sealights.plugins.engine.lifecycle.ExecutionIdHandler;
import io.sealights.plugins.engine.lifecycle.events.PluginAgentEventsController;
import lombok.Generated;
import org.slf4j.Logger;

public enum BuildLifeCycle {
    INSTANCE;

    private volatile PluginExecData execData;
    private volatile boolean loggerInitilized = false;
    private volatile boolean started = false;
    private PluginAgentEventsController eventsController;
    private ExecutionIdHandler testExecutionIdHandler;
    private Logger logger;

    public static synchronized void initLogger(PluginGoal pluginGoal) {
        INSTANCE.setLogger(pluginGoal.getLogger());
    }

    public static synchronized void notifyStart(PluginGoal pluginGoal) {
        INSTANCE.startPlugin(pluginGoal);
    }

    public static synchronized void notifyError(String error) {
        BuildLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.ERROR, error);
    }

    public static void notifyWarning(String warning) {
        BuildLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.WARNING, warning);
    }

    public static synchronized void startTestStageExecutionForTstListener(PluginGoal pluginGoal) {
        INSTANCE.startTestStageExecution(pluginGoal);
    }

    public static synchronized void notifyInfo(String info) {
        BuildLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.INFO, info);
    }

    public static synchronized void notifyBuildEnd(PluginGoal pluginGoal, BuildEndInfo buildEndInfo) {
        INSTANCE.shutdown(pluginGoal, buildEndInfo);
    }

    public static PluginExecData getExecData() {
        return BuildLifeCycle.INSTANCE.execData;
    }

    public static synchronized boolean isScannedProject(String projectName) {
        return BuildLifeCycle.INSTANCE.execData.isScannedProject(projectName);
    }

    public static synchronized boolean isBuildScannerInvoked() {
        return BuildLifeCycle.INSTANCE.execData.isBuildScannerInvoked();
    }

    public static void resetForTests() {
        INSTANCE.init();
    }

    private BuildLifeCycle() {
        this.init();
    }

    private void init() {
        this.execData = new PluginExecData();
        this.started = false;
        this.loggerInitilized = false;
        this.eventsController = new PluginAgentEventsController(this.execData);
        this.testExecutionIdHandler = new ExecutionIdHandler(this.execData);
    }

    private void setLogger(Logger pluginLogger) {
        if (this.loggerInitilized) {
            return;
        }
        this.logger = pluginLogger;
    }

    private void startPlugin(PluginGoal pluginGoal) {
        if (this.started) {
            return;
        }
        this.logger.info("BuildLifeCycle: startPlugin");
        this.eventsController.startAgent(pluginGoal);
        this.started = true;
    }

    private void startTestStageExecution(PluginGoal pluginGoal) {
        this.testExecutionIdHandler.startExecution(pluginGoal);
    }

    private void shutdown(PluginGoal pluginGoal, BuildEndInfo buildEndInfo) {
        if (this.started) {
            this.logger.info("BuildLifeCycle: shutdown");
            this.testExecutionIdHandler.endExecution();
            if (this.execData.isBuildScannerInvoked()) {
                this.logger.info("Scanned modules: {}", (Object)ToStringFormatter.toString(this.execData.getProjectsExecData().keySet()));
                this.eventsController.notifyBuildEnd(pluginGoal, buildEndInfo);
            }
            this.eventsController.stop();
        }
        if (pluginGoal.getPluginType() == PluginType.gradle) {
            this.init();
        }
    }

    @Generated
    public PluginAgentEventsController getEventsController() {
        return this.eventsController;
    }

    @Generated
    public void setEventsController(PluginAgentEventsController eventsController) {
        this.eventsController = eventsController;
    }

    @Generated
    public ExecutionIdHandler getTestExecutionIdHandler() {
        return this.testExecutionIdHandler;
    }

    @Generated
    public void setTestExecutionIdHandler(ExecutionIdHandler testExecutionIdHandler) {
        this.testExecutionIdHandler = testExecutionIdHandler;
    }
}

