/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.lifecycle;

import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.serviceproxy.executionstate.ExecutionStateProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.executionstate.ExecutionStateProxyHandler;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;

public class ExecutionIdHandler {
    private List<String> executions = new ArrayList<String>();
    private ExecutionStateProxy executionProxyHandler;
    private BuildSessionData buildSessionData;
    private String labId;
    private String testGroupId;
    private Logger pluginLogger;
    private PluginExecData execData;

    public ExecutionIdHandler(PluginExecData execDataGuard) {
        this.execData = execDataGuard;
    }

    public void startExecution(PluginGoal pluginGoal) {
        if (!pluginGoal.getParams().getGeneralParams().isCreateExecutionId()) {
            return;
        }
        this.init(pluginGoal);
        String currentTestStage = pluginGoal.getParams().getGeneralParams().getTestStage();
        if (StringUtils.isNullOrEmpty(currentTestStage)) {
            this.pluginLogger.info("cannot create execution for empty testStage");
            return;
        }
        if (this.execData.hasExecution(currentTestStage)) {
            this.pluginLogger.info("using existing execution '{}' for testStage '{}'", (Object)this.execData.getExecution(currentTestStage), (Object)currentTestStage);
            return;
        }
        String executionId = UUID.randomUUID().toString();
        this.executions.add(executionId);
        this.execData.addExecution(currentTestStage, executionId);
        if (this.executionProxyHandler.startColoredExecution(executionId, currentTestStage, this.buildSessionData, this.labId, this.testGroupId)) {
            this.pluginLogger.info("started execution '{}' for testStage '{}'", (Object)executionId, (Object)currentTestStage);
        } else {
            this.pluginLogger.warn("failed to start execution for testStage '{}'", (Object)currentTestStage);
        }
    }

    public void endExecution() {
        if (this.executions.isEmpty()) {
            return;
        }
        for (String executionId : this.executions) {
            boolean executionEnded = this.executionProxyHandler.endColoredExecution(executionId, this.buildSessionData, this.labId, this.testGroupId);
            if (executionEnded) {
                this.pluginLogger.info("ended execution '{}'", (Object)executionId);
                continue;
            }
            this.pluginLogger.warn("failed to end execution");
        }
    }

    private void init(PluginGoal pluginGoal) {
        if (this.executionProxyHandler == null) {
            this.executionProxyHandler = new ExecutionStateProxyHandler(this.execData.getToken(), this.execData.getTokenData().getServer(), pluginGoal.getParams().getGeneralParams().getProxy(), BuildLifeCycle.INSTANCE.getEventsController());
        }
        this.buildSessionData = this.execData.getBuildSessionData();
        this.labId = pluginGoal.getParams().getGeneralParams().getLabId();
        this.pluginLogger = pluginGoal.getLogger();
        this.testGroupId = SystemPropertiesHelper.getStrProperty("sl.testGroupId", null);
    }

    @Generated
    public List<String> getExecutions() {
        return this.executions;
    }

    @Generated
    public void setExecutionProxyHandler(ExecutionStateProxy executionProxyHandler) {
        this.executionProxyHandler = executionProxyHandler;
    }
}

