/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.lifecycle.events;

import io.sealights.onpremise.agentevents.engine.AgentDescriptor;
import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.ExecutionStage;
import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginParameters;
import io.sealights.plugins.engine.lifecycle.BuildEndInfo;
import io.sealights.plugins.engine.lifecycle.events.PluginParamsConverter;
import java.io.File;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class PluginAgentEventsController
extends AgentEventsController {
    private AgentStartInfo.ToolInfo toolInfo = new AgentStartInfo.ToolInfo();
    private EndOfBuildHandler endOfBuildHandler = new EndOfBuildHandler();
    private PluginParameters pluginParams;
    private Logger goalLogger;
    private boolean initialized = false;
    private PluginExecData execData;

    public PluginAgentEventsController(PluginExecData execDataGuard) {
        this.execData = execDataGuard;
    }

    public synchronized void startAgent(PluginGoal pluginGoal) {
        if (!this.initialized) {
            this.init(pluginGoal);
            this.sendStartEvent();
            this.initialized = true;
        }
    }

    public void init(PluginGoal pluginGoal) {
        AgentDescriptor agentDescriptor = new AgentDescriptor(pluginGoal.getPluginType().getAgentType(), this.execData.getProjectDescriptor(pluginGoal.getModuleName()).getPluginVersion(), this.execData.getAppName(), this.execData.getBuildSessionId(), false);
        super.init(agentDescriptor, this.execData.getToken(), this.execData.getServer(), pluginGoal.getParams().getGeneralParams().getProxy());
        this.initToolName();
        this.toolInfo.setVersion(pluginGoal.getBuildToolVersion());
        this.goalLogger = pluginGoal.getLogger();
        this.pluginParams = pluginGoal.getParams();
    }

    @Override
    public AgentStartInfo.ToolInfo getToolInfo() {
        return this.toolInfo;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        PluginParamsConverter converter = new PluginParamsConverter(this.pluginParams, this.goalLogger);
        return converter.toKeyValueMap();
    }

    public synchronized void notifyBuildEnd(PluginGoal pluginGoal, BuildEndInfo buildEndInfo) {
        if (this.execData.getExecStage() == ExecutionStage.initOk) {
            EndBuildEventRequest endBuildRequest = this.endOfBuildHandler.handleBuildEnd(this.execData, pluginGoal.getLogger(), buildEndInfo);
            this.sendBuildEndEvent(endBuildRequest);
        }
    }

    private void initToolName() {
        String toolName = "";
        switch (this.getAgentDescriptor().getAgentType()) {
            case MavenPlugin: {
                toolName = "maven";
                break;
            }
            case GradlePlugin: {
                toolName = "gradle";
                break;
            }
        }
        this.toolInfo.setName(toolName);
    }

    @Generated
    public void setToolInfo(AgentStartInfo.ToolInfo toolInfo) {
        this.toolInfo = toolInfo;
    }

    @Generated
    public void setEndOfBuildHandler(EndOfBuildHandler endOfBuildHandler) {
        this.endOfBuildHandler = endOfBuildHandler;
    }

    @Generated
    public PluginExecData getExecData() {
        return this.execData;
    }

    public static class EndOfBuildHandler {
        public EndBuildEventRequest handleBuildEnd(PluginExecData execData, Logger goalLogger, BuildEndInfo buildEndInfo) {
            this.deleteMetaDataFiles(execData, goalLogger);
            return this.createEndBuildEventRequest(execData, buildEndInfo);
        }

        public EndBuildEventRequest createEndBuildEventRequest(PluginExecData execData, BuildEndInfo buildEndInfo) {
            EndBuildEventRequest request = new EndBuildEventRequest(execData.getTokenData().getCustomerId(), execData.getBuildSessionData().getAppName(), execData.getBuildSessionData().getBuildName(), execData.getBuildSessionData().getBranchName(), new EndBuildEventRequest.EventStatus(buildEndInfo.isSuccess(), buildEndInfo.getBuildDurationMSec(), buildEndInfo.getFailureReason()));
            return request;
        }

        private void deleteMetaDataFiles(PluginExecData execData, Logger goalLogger) {
            List<String> metaDataFiles = execData.getProjectsMetaDataFiles();
            for (String fileName : metaDataFiles) {
                File f;
                if (StringUtils.isNullOrEmpty(fileName) || !(f = new File(fileName)).exists() || f.delete()) continue;
                goalLogger.warn("Failed to delete '{}'", (Object)fileName);
            }
        }
    }
}

