/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.lifecycle.events;

import io.sealights.plugins.engine.api.PluginParameters;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class PluginParamsConverter {
    private Map<String, String> propsKeyValueMap = new HashMap<String, String>();
    private PluginParameters params;
    private Logger goalLogger;
    public static final String NULL_VALUE = "null";
    protected static final String EMPTY_VALUE = "empty";
    protected static final String CONTINUE_LIST = ", ";
    private static String GET_PREFIX = "get";
    private static String IS_PREFIX = "is";
    private static String[] EXCLUDED_GETTERS = new String[]{"getSystemProperty", "getSealightsJvmParams", "getBuildScannerParams", "getTestListenerJvmParams"};

    public PluginParamsConverter(PluginParameters params, Logger goalLogger) {
        this.params = params;
        this.goalLogger = goalLogger;
    }

    public Map<String, String> toKeyValueMap() {
        this.putSimpleProperties(this.params.getGeneralParams());
        this.putMapProperty("sealightsJvmParams", this.params.getGeneralParams().getSealightsJvmParams());
        this.putSimpleProperties(this.params.getBldScanrParams());
        this.putMapProperty("buildScannerParams", this.params.getBldScanrParams().getBuildScannerParams());
        this.putSimpleProperties(this.params.getTstListnrParams());
        this.putMapProperty("testListenerJvmParams", this.params.getTstListnrParams().getTestListenerJvmParams());
        return this.propsKeyValueMap;
    }

    private void putSimpleProperties(Object params) {
        if (params != null) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = params.getClass().getDeclaredMethods()) {
                this.putGetter(method, params);
            }
        }
    }

    private void putMapProperty(String propName, Map<String, ?> propValues) {
        if (propValues == null) {
            this.propsKeyValueMap.put(propName, NULL_VALUE);
            return;
        }
        if (propValues.isEmpty()) {
            this.propsKeyValueMap.put(propName, EMPTY_VALUE);
            return;
        }
        if (propValues != null) {
            for (String nestedKey : propValues.keySet()) {
                Object value = propValues.get(nestedKey);
                this.propsKeyValueMap.put(String.format("%s.%s", propName, nestedKey), value != null ? value.toString() : NULL_VALUE);
            }
        }
    }

    private void putGetter(Method method, Object params) {
        if (method.getName().startsWith(GET_PREFIX) && !this.isExcludedGetter(method.getName()) || method.getName().startsWith(IS_PREFIX)) {
            try {
                String key = this.extractPropName(method, params);
                Object value = method.invoke(params, new Object[0]);
                this.propsKeyValueMap.put(key, value != null ? value.toString() : NULL_VALUE);
            }
            catch (Exception e) {
                this.goalLogger.error("Failed to read property : '{}'. Error: {}", (Object)method, (Object)e);
            }
        }
    }

    private boolean isExcludedGetter(String methodName) {
        for (String ex : EXCLUDED_GETTERS) {
            if (!ex.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private String extractPropName(Method method, Object params) {
        String methodName = method.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            methodName = methodName.replaceFirst(GET_PREFIX, "");
        }
        if (methodName.startsWith(IS_PREFIX)) {
            methodName = methodName.replaceFirst(IS_PREFIX, "");
        }
        return methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
    }
}

