/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.lifecycle.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.EventTypes;
import java.util.Map;
import lombok.Generated;

public class SimpleEvent {
    @JsonProperty(value="type")
    EventTypes eventType;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="meta")
    private Map<String, Object> meta;
    @JsonProperty(value="threadId")
    private Long threadId;

    public SimpleEvent(EventTypes eventType, Map<String, Object> meta) {
        this.eventType = eventType;
        this.meta = meta;
        this.timestamp = System.currentTimeMillis();
        this.threadId = Thread.currentThread().getId();
    }

    public SimpleEvent(EventTypes eventType, Map<String, Object> meta, long currentTimeMs) {
        this.eventType = eventType;
        this.meta = meta;
        this.timestamp = currentTimeMs;
        this.threadId = Thread.currentThread().getId();
    }

    public String toString() {
        return String.format("eventType=%s, timestamp=%s, threadId=%s, %s%n", new Object[]{this.eventType, this.timestamp, this.threadId, this.toString(this.meta)});
    }

    private String toString(Map<String, Object> meta) {
        StringBuilder buf = new StringBuilder("metadata:\n");
        if (meta == null || meta.isEmpty()) {
            buf.append("empty");
        } else {
            for (String key : meta.keySet()) {
                buf.append(String.format("\t[%-20s] : %s%n", key, meta.get(key)));
            }
        }
        return buf.toString();
    }

    @Generated
    public EventTypes getEventType() {
        return this.eventType;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @Generated
    public Long getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="type")
    @Generated
    public void setEventType(EventTypes eventType) {
        this.eventType = eventType;
    }

    @JsonProperty(value="timestamp")
    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="meta")
    @Generated
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    @JsonProperty(value="threadId")
    @Generated
    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleEvent)) {
            return false;
        }
        SimpleEvent other = (SimpleEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Long this$threadId = this.getThreadId();
        Long other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !((Object)this$threadId).equals(other$threadId)) {
            return false;
        }
        EventTypes this$eventType = this.getEventType();
        EventTypes other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        Map<String, Object> this$meta = this.getMeta();
        Map<String, Object> other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Long $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : ((Object)$threadId).hashCode());
        EventTypes $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        Map<String, Object> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }
}

