/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class BuildProjectMetadataProc
extends PluginGoalProc {
    private static final String MAVEN_DEPENDENCIES_KEY = "projectDependencies";
    private static final String BUILD_TOOL = "maven";
    private final String META_JSON_PREFIX_PATH = System.getProperty("java.io.tmpdir");
    private static final String METADATA_ = "metadata_";
    private static final String DOT_JSON = ".json";
    private Map<String, Object> metadata;

    public BuildProjectMetadataProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public String getName() {
        return "BuildProjectMetaData";
    }

    @Override
    public void execute() {
        String fileName;
        boolean isSucceed;
        if (this.getExecData().getProjectMetaDataFilePath(this.getModuleName()) != null) {
            this.setSuccess();
            return;
        }
        this.metadata = this.getGeneralParams().getMetadata();
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put("buildTool", BUILD_TOOL);
        if (!this.getProjectDescriptor().getDependencies().isEmpty()) {
            this.metadata.put(MAVEN_DEPENDENCIES_KEY, this.getProjectDescriptor().getDependencies());
        }
        if (isSucceed = this.writeToJsonFile(fileName = this.getMetaJsonFileName(), this.metadata)) {
            this.getExecData().setProjectMetaDataFilePath(this.getModuleName(), fileName);
            this.setSuccess();
        }
    }

    private String getMetaJsonFileName() {
        if (!StringUtils.isNullOrEmpty(this.getGeneralParams().getOverrideMetaJsonPath())) {
            return this.getGeneralParams().getOverrideMetaJsonPath();
        }
        if (!StringUtils.isNullOrEmpty(this.getGeneralParams().getFilesStorage())) {
            return PathUtils.join(this.getGeneralParams().getFilesStorage(), METADATA_ + UUID.randomUUID() + DOT_JSON);
        }
        return PathUtils.join(this.META_JSON_PREFIX_PATH, METADATA_ + UUID.randomUUID() + DOT_JSON);
    }

    private boolean writeToJsonFile(String fileName, Object data) {
        try {
            ObjectMapper om = new ObjectMapper();
            om.writeValue(new File(fileName), data);
            this.getGoalLogger().info("Created metada file '{}' for project '{}'", (Object)fileName, (Object)this.getModuleName());
            return true;
        }
        catch (Exception e) {
            this.setFailure("Unable to save project metadata to file'" + fileName + "'", e);
            return false;
        }
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }
}

