/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.TstListnrCliData;
import io.sealights.plugins.engine.clibuilders.TstListnrCliBuilder;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;

public class BuildTstLisnrCliProc
extends PluginGoalProc {
    private static final String ERR_PREFIX = "Test listener CLI ";

    public BuildTstLisnrCliProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public void execute() {
        TstListnrCliBuilder cliBuilder = new TstListnrCliBuilder(this.getGoal(), this.getExecData());
        TstListnrCliData cliData = cliBuilder.executeAsCliData();
        if (this.isValidCliArg(cliData)) {
            this.getExecData().setTstLisnrCliData(this.getModuleName(), cliData);
            this.setSuccess();
        } else {
            this.setFailure("Failed prepare test listener args line");
        }
    }

    private boolean isValidCliArg(TstListnrCliData cliData) {
        switch (this.getGoal().getPluginType()) {
            case maven: {
                return this.isValidJavaAgentArg(cliData.getMavenPluginTstLisnrCli());
            }
            case gradle: {
                return this.isValidJavaAgentArg(cliData.getGradlePluginJavaAgentArg());
            }
        }
        return false;
    }

    private boolean isValidJavaAgentArg(String cliStr) {
        if (StringUtils.isNullOrEmpty(cliStr)) {
            this.setFailure("Test listener CLI is empty");
            return false;
        }
        if (!cliStr.contains("javaagent:")) {
            this.setFailure(String.format("%s does not contain the argument '%s'", ERR_PREFIX, "javaagent:"));
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "BuildTstListnrJvmArgs";
    }
}

