/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginExecResult;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import io.sealights.plugins.engine.procs.BuildBldScanrCliProcGradle;
import io.sealights.plugins.engine.procs.ExecutePluginGoalProc;
import io.sealights.plugins.engine.procs.RunBldScanrProcMaven;
import io.sealights.plugins.engine.procsexecutor.PluginEngineHandler;
import io.sealights.plugins.engine.utils.DefaultFilesToJarWriter;

public class ExecuteBldScanrGoalProc
extends ExecutePluginGoalProc {
    private static final String SKIP_BLD_SCANNER_MSG = "skip build-scanner:";

    public ExecuteBldScanrGoalProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public PluginExecResult executeGoal() {
        PluginExecResult execResult = new PluginExecResult();
        this.addSealightsResources();
        if (this.getGeneralParams().isRunTestOnly() || this.getGeneralParams().isRunFunctionalTests()) {
            this.getGoalLogger().info("skip build-scanner:: test-only mode");
            return execResult;
        }
        if (BuildLifeCycle.isScannedProject(this.getModuleName())) {
            this.getGoalLogger().info("skip build-scanner: project '{}' was already scanned", (Object)this.getModuleName());
            return execResult;
        }
        switch (this.getGoal().getPluginType()) {
            case maven: {
                execResult = PluginEngineHandler.executeProcedure(new RunBldScanrProcMaven(this.getGoal()), true);
                break;
            }
            case gradle: {
                execResult = PluginEngineHandler.executeProcedure(new BuildBldScanrCliProcGradle(this.getGoal()), true);
            }
        }
        this.getExecData().setPorjectScanResult(this.getModuleName(), execResult.isOk());
        return execResult;
    }

    private void addSealightsResources() {
        if (!this.getGeneralParams().isIncludeResources()) {
            this.getGoalLogger().info("Default token and buildSessionId will not be created");
            return;
        }
        String defaultFilesFolder = this.getDefaultFilesFolder();
        if (StringUtils.isNullOrEmpty(defaultFilesFolder)) {
            this.getGoalLogger().info("Cannot create default token and buildSessionId files - folder cannot be resolved");
        }
        boolean includeToken = this.getGeneralParams().isIncludeTokenResource();
        DefaultFilesToJarWriter writer = new DefaultFilesToJarWriter();
        if (includeToken) {
            try {
                writer.execute(this.getDefaultFilesFolder(), this.getExecData().getToken(), this.getExecData().getBuildSessionId());
                this.getGoalLogger().info("Default token and buildSessionId files were created in '{}'", (Object)defaultFilesFolder);
            }
            catch (Exception e) {
                this.getGoalLogger().info("Failed to create default token and buildSessionId files in {}, error:{}", (Object)defaultFilesFolder, (Object)e.getMessage());
            }
        } else {
            try {
                writer.execute(this.getDefaultFilesFolder(), null, this.getExecData().getBuildSessionId());
                this.getGoalLogger().info("The buildSessionId file were created in '{}'", (Object)defaultFilesFolder);
            }
            catch (Exception e) {
                this.getGoalLogger().info("Failed to create buildSessionId file in {}, error:{}", (Object)defaultFilesFolder, (Object)e.getMessage());
            }
        }
    }

    private String getDefaultFilesFolder() {
        switch (this.getGoal().getPluginType()) {
            case maven: {
                return this.getProjectDescriptor().getBuildOutputDirectory();
            }
            case gradle: {
                return PathUtils.join(this.getProjectDescriptor().getBuildOutputDirectory(), "resources", "main");
            }
        }
        return null;
    }
}

