/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.http.api.AgentIdentificationDataHolder;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.plugins.engine.api.PluginExecResult;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.ProjectDescriptor;
import io.sealights.plugins.engine.procs.BuildProjectMetadataProc;
import io.sealights.plugins.engine.procs.InitPluginExecutionProc;
import io.sealights.plugins.engine.procsexecutor.PluginEngineHandler;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;

public abstract class ExecutePluginGoalProc
extends PluginGoalProc {
    private static final ConsoleLogger CONSOLE_LOG = PluginEngineHandler.getConsoleLog();
    private static final String SEALIGHTS_SKIP_PROPERTY = "sealights.skip";
    private InitPluginExecutionProc initExecutionStep;
    private BuildProjectMetadataProc buildProjectMetaDataStep;
    private static final List<String> skippedModules = new ArrayList<String>();

    public ExecutePluginGoalProc(PluginGoal goal) {
        super(goal);
        this.initExecutionStep = new InitPluginExecutionProc(goal);
        this.buildProjectMetaDataStep = new BuildProjectMetadataProc(goal);
    }

    @Override
    public String getName() {
        return "ExecutePluginGoal";
    }

    @Override
    public void execute() {
        try {
            this.getGoal().initGoalInternals();
            this.getExecData().initProjectDescriptor(this.getModuleName(), this.getGoal());
            this.getGoalLogger().debug("Setting sl-metadata agentVersion '{}'", (Object)this.getExecData().getProjectDescriptor(this.getGoal().getModuleName()).getPluginVersion());
            AgentIdentificationDataHolder.setAgentVersion(this.getExecData().getProjectDescriptor(this.getGoal().getModuleName()).getPluginVersion());
            if (this.isValidForExecution()) {
                if (this.skipProject(this.getProjectDescriptor())) {
                    this.setSuccess();
                } else {
                    this.executeValidGoal();
                }
            } else {
                this.setResultFailure();
            }
        }
        catch (Throwable e) {
            this.setResultFailure(e);
        }
        if (!this.getResult().isOk()) {
            this.handleExecutionError();
        }
    }

    public abstract PluginExecResult executeGoal();

    protected void executeValidGoal() {
        this.getGoalLogger().info("Executing goal '{}'", (Object)this.getGoal().getName());
        this.executeSubProc(this.buildProjectMetaDataStep);
        PluginExecResult pluginGoalResult = this.executeGoal();
        if (pluginGoalResult.isOk()) {
            this.setSuccess();
            if (this.getGoal().postExecute()) {
                this.getGoalLogger().info("Successfully executed goal '{}' ", (Object)this.getGoal().getName());
            } else {
                this.getResult().setFailure("goal failed in post-execute");
            }
        } else {
            this.getResult().setFailure(pluginGoalResult.getErrorMsgs());
        }
    }

    protected void handleExecutionError() {
        this.getGoal().onFailure();
    }

    private boolean isValidForExecution() {
        switch (this.getExecData().getExecStage()) {
            case initOk: {
                return true;
            }
            case initFailed: {
                return false;
            }
            case init: {
                return this.initPlugin();
            }
        }
        return false;
    }

    private boolean initPlugin() {
        if (this.executeSubProc(this.initExecutionStep)) {
            this.getExecData().setInitState(true);
            this.getGoal().getLogger().info("Initializing done");
            return true;
        }
        this.getExecData().setInitState(false);
        this.getGoal().getLogger().info("Initializing failed; errors:{}", this.getResult().getErrorMsgs());
        return false;
    }

    private boolean skipProject(ProjectDescriptor projectDescriptor) {
        String skip;
        if (projectDescriptor == null) {
            return true;
        }
        if (skippedModules.contains(projectDescriptor.getProjectName())) {
            return true;
        }
        if (this.addProjectToSkippedModulesIfNeeded(projectDescriptor.getProjectName())) {
            return true;
        }
        Properties properties = projectDescriptor.getProperties();
        if (properties != null && Boolean.parseBoolean(skip = properties.getProperty(SEALIGHTS_SKIP_PROPERTY))) {
            skippedModules.add(projectDescriptor.getProjectName());
            CONSOLE_LOG.info("skip SEALIGHTS integration" + String.format(" for project '%s' with a property 'sealights.skip'='true'", projectDescriptor.getProjectName()));
            return true;
        }
        return false;
    }

    private boolean addProjectToSkippedModulesIfNeeded(String projectName) {
        String slModulesToSkip = System.getProperty("sl.modulesToSkip");
        if (slModulesToSkip != null) {
            String[] modulesToSkip;
            for (String module : modulesToSkip = slModulesToSkip.split(",")) {
                if (!module.equalsIgnoreCase(projectName)) continue;
                skippedModules.add(projectName);
                CONSOLE_LOG.info("skip SEALIGHTS integration" + String.format(" project '%s' which is listed in the system property %s", projectName, "sl.modulesToSkip"));
                return true;
            }
        }
        return false;
    }

    @Generated
    public InitPluginExecutionProc getInitExecutionStep() {
        return this.initExecutionStep;
    }

    @Generated
    public BuildProjectMetadataProc getBuildProjectMetaDataStep() {
        return this.buildProjectMetaDataStep;
    }

    @Generated
    public void setInitExecutionStep(InitPluginExecutionProc initExecutionStep) {
        this.initExecutionStep = initExecutionStep;
    }

    @Generated
    public void setBuildProjectMetaDataStep(BuildProjectMetadataProc buildProjectMetaDataStep) {
        this.buildProjectMetaDataStep = buildProjectMetaDataStep;
    }

    @Override
    @Generated
    public String toString() {
        return "ExecutePluginGoalProc(initExecutionStep=" + this.getInitExecutionStep() + ", buildProjectMetaDataStep=" + this.getBuildProjectMetaDataStep() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutePluginGoalProc)) {
            return false;
        }
        ExecutePluginGoalProc other = (ExecutePluginGoalProc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InitPluginExecutionProc this$initExecutionStep = this.getInitExecutionStep();
        InitPluginExecutionProc other$initExecutionStep = other.getInitExecutionStep();
        if (this$initExecutionStep == null ? other$initExecutionStep != null : !((Object)this$initExecutionStep).equals(other$initExecutionStep)) {
            return false;
        }
        BuildProjectMetadataProc this$buildProjectMetaDataStep = this.getBuildProjectMetaDataStep();
        BuildProjectMetadataProc other$buildProjectMetaDataStep = other.getBuildProjectMetaDataStep();
        return !(this$buildProjectMetaDataStep == null ? other$buildProjectMetaDataStep != null : !((Object)this$buildProjectMetaDataStep).equals(other$buildProjectMetaDataStep));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutePluginGoalProc;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InitPluginExecutionProc $initExecutionStep = this.getInitExecutionStep();
        result = result * 59 + ($initExecutionStep == null ? 43 : ((Object)$initExecutionStep).hashCode());
        BuildProjectMetadataProc $buildProjectMetaDataStep = this.getBuildProjectMetaDataStep();
        result = result * 59 + ($buildProjectMetaDataStep == null ? 43 : ((Object)$buildProjectMetaDataStep).hashCode());
        return result;
    }
}

