/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.configuration.UpgradeConfigurationMapper;
import io.sealights.onpremise.agents.infra.upgrade.BuildScannerUpgraderFactory;
import io.sealights.onpremise.agents.infra.upgrade.ComponentUpgrader;
import io.sealights.onpremise.agents.infra.upgrade.TestListenerPluginUpgrader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;

public class InitAgentsLocationProc
extends PluginGoalProc {
    private ComponentUpgrader bldScannerUpgrader;
    private ComponentUpgrader tstListnrUpgrader;

    public InitAgentsLocationProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public void execute() {
        this.init();
        if (this.resolveBldScanrPath() && this.resolveTstLisnrPath()) {
            this.setSuccess();
        }
    }

    @Override
    public String getName() {
        return "GetAgentsLocation";
    }

    protected void init() {
        if (this.bldScannerUpgrader == null && this.tstListnrUpgrader == null) {
            UpgradeConfiguration upgradeConfiguration = this.createUpgradeConfiguration();
            this.bldScannerUpgrader = BuildScannerUpgraderFactory.createPluginUpgrader(upgradeConfiguration);
            this.tstListnrUpgrader = new TestListenerPluginUpgrader(upgradeConfiguration);
        }
    }

    private boolean resolveBldScanrPath() {
        String tempPath = this.resolveAgentJarPath(this.getGeneralParams().getBuildScannerJar(), this.bldScannerUpgrader);
        if (StringUtils.isNotEmpty(tempPath)) {
            this.getExecData().setBldScanrLocation(tempPath);
            return true;
        }
        this.setFailure("Failed to resolve path to the build scanner. Sealights is disabled.");
        return false;
    }

    private boolean resolveTstLisnrPath() {
        String tempPath = this.resolveAgentJarPath(this.getGeneralParams().getTestListenerJar(), this.tstListnrUpgrader);
        if (StringUtils.isNotEmpty(tempPath)) {
            this.getExecData().setTstLisnrLocation(tempPath);
            return true;
        }
        this.setFailure("Failed to resolve path to the test listener. Sealights is disabled.");
        return false;
    }

    private String resolveAgentJarPath(String jarPath, ComponentUpgrader upgrader) {
        if (StringUtils.isNullOrEmpty(jarPath)) {
            return this.resolveRecommendedJar(upgrader);
        }
        Path path = Paths.get(jarPath, new String[0]);
        return path.isAbsolute() ? this.validateAbsolutePath(jarPath) : this.resolveValidAbsolutePath(jarPath);
    }

    private String resolveRecommendedJar(ComponentUpgrader upgrader) {
        try {
            String agentPath = upgrader.resolveRecommendedJarPath();
            this.getGoalLogger().info("Using recommended version '{}'", (Object)agentPath);
            return agentPath;
        }
        catch (Exception e) {
            return (String)this.setFailure("Failed to resolve recommended agent jar", e);
        }
    }

    private String validateAbsolutePath(String jarPath) {
        File file = new File(jarPath);
        if (file.exists()) {
            return jarPath;
        }
        return (String)this.setFailure(String.format("Wrong jar path input '%s' - file does not exist", jarPath));
    }

    private String resolveValidAbsolutePath(String jarPath) {
        String resolvedJarPath = this.getGoal().locateFile(jarPath);
        if (resolvedJarPath != null) {
            this.getGoalLogger().info("Using provided jar '{}' ", (Object)resolvedJarPath);
            return resolvedJarPath;
        }
        return (String)this.setFailure(String.format("Wrong jar path input '%s' - file does not exist", jarPath));
    }

    private UpgradeConfiguration createUpgradeConfiguration() {
        UpgradeConfiguration cfg = new UpgradeConfiguration(this.getExecData().getToken(), this.getExecData().getCustomerId(), this.getExecData().getBuildSessionData().getAppName(), this.getGeneralParams().getEnvironment(), this.getExecData().getBuildSessionData().getBranchName(), this.getExecData().getServer(), this.getGeneralParams().getProxy(), this.getGeneralParams().getFilesStorage(), true);
        cfg = UpgradeConfigurationMapper.updateConfigurationFromSysProperties(cfg);
        if (this.getExecData().getTokenData() != null) {
            cfg.setCustomerId(this.getExecData().getTokenData().getCustomerId());
            cfg.setServer(this.getExecData().getTokenData().getServer());
            cfg.setToken(this.getExecData().getToken());
        }
        return cfg;
    }

    @Generated
    public ComponentUpgrader getBldScannerUpgrader() {
        return this.bldScannerUpgrader;
    }

    @Generated
    public ComponentUpgrader getTstListnrUpgrader() {
        return this.tstListnrUpgrader;
    }

    @Generated
    public void setBldScannerUpgrader(ComponentUpgrader bldScannerUpgrader) {
        this.bldScannerUpgrader = bldScannerUpgrader;
    }

    @Generated
    public void setTstListnrUpgrader(ComponentUpgrader tstListnrUpgrader) {
        this.tstListnrUpgrader = tstListnrUpgrader;
    }

    @Override
    @Generated
    public String toString() {
        return "InitAgentsLocationProc(bldScannerUpgrader=" + this.getBldScannerUpgrader() + ", tstListnrUpgrader=" + this.getTstListnrUpgrader() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitAgentsLocationProc)) {
            return false;
        }
        InitAgentsLocationProc other = (InitAgentsLocationProc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComponentUpgrader this$bldScannerUpgrader = this.getBldScannerUpgrader();
        ComponentUpgrader other$bldScannerUpgrader = other.getBldScannerUpgrader();
        if (this$bldScannerUpgrader == null ? other$bldScannerUpgrader != null : !this$bldScannerUpgrader.equals(other$bldScannerUpgrader)) {
            return false;
        }
        ComponentUpgrader this$tstListnrUpgrader = this.getTstListnrUpgrader();
        ComponentUpgrader other$tstListnrUpgrader = other.getTstListnrUpgrader();
        return !(this$tstListnrUpgrader == null ? other$tstListnrUpgrader != null : !this$tstListnrUpgrader.equals(other$tstListnrUpgrader));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InitAgentsLocationProc;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentUpgrader $bldScannerUpgrader = this.getBldScannerUpgrader();
        result = result * 59 + ($bldScannerUpgrader == null ? 43 : $bldScannerUpgrader.hashCode());
        ComponentUpgrader $tstListnrUpgrader = this.getTstListnrUpgrader();
        result = result * 59 + ($tstListnrUpgrader == null ? 43 : $tstListnrUpgrader.hashCode());
        return result;
    }
}

