/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.configuration.validation.BuildSessionFlow;
import io.sealights.onpremise.agents.infra.configuration.validation.BuildSessionIdFlowResolver;
import io.sealights.onpremise.agents.infra.configuration.validation.PackagesIncludedValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.http.api.AgentIdentificationDataHolder;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.serviceproxy.labids.LabIdsServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.labids.LabIdsServiceProxyHandler;
import io.sealights.onpremise.agents.infra.time.sync.TimeClockServiceHandler;
import io.sealights.onpremise.agents.infra.time.sync.utils.TimeClockDispatcher;
import io.sealights.onpremise.agents.infra.types.AdditionalArgumentsData;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.types.PullRequestParams;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.BuildNameResolver;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import lombok.Generated;

public class InitBuildSessionIdProc
extends PluginGoalProc {
    private static final String APP_NAME = "appName";
    private static final String BUILD = "build";
    private static final String BRANCH = "branch";
    private static final String REPOSITORY_URL = "repositoryUrl";
    private static final String PULL_REQUEST_NUMBER = "pullRequestNumber";
    private static final String LATEST_COMMIT = "latestCommit";
    private static final String TARGET_BRUNCH = "targetBranch";
    private static final String PACKAGES_INCLUDED = "packagesincluded";
    private static final String CREATE_BUILD_SESSION_ID = "createBuildSessionId";
    private static final String CREATE_PR_BUILD_SESSION_ID = "createPRBuildSessionId";
    private BuildSessionServiceProxy buildSessionIdProxy = null;
    private LabIdsServiceProxy labIdsProxy = null;
    private final PackagesIncludedValidator packagesIncludedValidator;
    private final BuildNameResolver buildNameResolver;

    public InitBuildSessionIdProc(PluginGoal goal) {
        this(goal, new PackagesIncludedValidator(), new BuildNameResolver());
    }

    public InitBuildSessionIdProc(PluginGoal goal, PackagesIncludedValidator packagesIncludedValidator, BuildNameResolver buildNameResolver) {
        super(goal);
        this.packagesIncludedValidator = packagesIncludedValidator;
        this.buildNameResolver = buildNameResolver;
    }

    private void initProxies() {
        if (this.buildSessionIdProxy == null) {
            this.buildSessionIdProxy = new BuildSessionServiceProxyHandler(this.getExecData().getToken(), this.getExecData().getTokenData().getServer(), this.getGeneralParams().getProxy());
        }
        if (this.labIdsProxy == null) {
            this.labIdsProxy = new LabIdsServiceProxyHandler(this.getExecData().getToken(), this.getExecData().getTokenData().getServer(), this.getGeneralParams().getProxy());
        }
    }

    @Override
    public String getName() {
        return "InitBuildSessionId";
    }

    @Override
    public void execute() {
        this.initProxies();
        String inputBuildSessionId = ArgumentFileReader.resolve(this.getGeneralParams().getBuildSessionId(), this.getGeneralParams().getBuildSessionIdFile());
        BuildSessionData tempBuildSessionData = null;
        BuildSessionFlow executionFlow = BuildSessionIdFlowResolver.resolveFlow(this.getGeneralParams().isCreateBuildSessionId(), this.getGeneralParams().isCreatePRBuildSessionId());
        switch (executionFlow) {
            case CREATE_BUILD_SESSION: {
                tempBuildSessionData = this.createBuildSessionId(inputBuildSessionId);
                break;
            }
            case CREATE_PR_BUILD_SESSION: {
                tempBuildSessionData = this.createPullRequestBuildSession(inputBuildSessionId);
                break;
            }
            case RESOLVE_EXISTING_SESSION: {
                tempBuildSessionData = this.resolveExistingBuildSession(inputBuildSessionId);
                break;
            }
            case ERROR_AMBIGUOUS_PARAMS: {
                this.setFailure("Ambiguous data: createPRBuildSessionId = true and createBuildSessionId=true, cannot create build session id.");
                return;
            }
        }
        if (tempBuildSessionData != null) {
            this.getGoalLogger().info("Build session was initialized successfully, buildSessionId:'{}'", (Object)tempBuildSessionData.getBuildSessionId());
            this.getExecData().setBuildSessionData(tempBuildSessionData);
            this.getExecData().setBuildSessionId(tempBuildSessionData.getBuildSessionId());
            this.warnIfInputOverridden(tempBuildSessionData);
            this.setSuccess();
            this.getGoalLogger().debug("Setting sl-metadata buildSessionId: '{}'", (Object)tempBuildSessionData.getBuildSessionId());
            AgentIdentificationDataHolder.setBuildSessionId(tempBuildSessionData.getBuildSessionId());
        }
    }

    private BuildSessionData createPullRequestBuildSession(String tempBuildSessionId) {
        if (!this.isValidPullRequestBSIDCreationData()) {
            return (BuildSessionData)this.setFailure("Invalid data, cannot create build session id.");
        }
        BuildSessionData buildSessionData = this.preparePRBuildSessionData(tempBuildSessionId);
        buildSessionData = this.buildSessionIdProxy.createPullRequestBuildSession(buildSessionData, null);
        return this.verifyCreateResult(buildSessionData, tempBuildSessionId);
    }

    private BuildSessionData preparePRBuildSessionData(String tempBuildSessionId) {
        PullRequestParams pullRequestParams = new PullRequestParams(this.getGeneralParams().getRepositoryUrl(), this.getGeneralParams().getPullRequestNumber(), this.getGeneralParams().getLatestCommit(), this.getGeneralParams().getTargetBranch());
        AdditionalArgumentsData additionalParams = new AdditionalArgumentsData(this.getGeneralParams().getPackagesIncluded(), this.getGeneralParams().getPackagesExcluded());
        BuildSessionData buildSessionData = new BuildSessionData(this.getGeneralParams().getAppName(), tempBuildSessionId, pullRequestParams, additionalParams);
        buildSessionData.setCustomerId(this.getExecData().getCustomerId());
        return buildSessionData;
    }

    private BuildSessionData createBuildSessionId(String tempBuildSessionId) {
        if (!this.isValidCreationData()) {
            return (BuildSessionData)this.setFailure("Invalid data, cannot create build session id.");
        }
        BuildSessionData buildSessionData = this.prepareBuildSessionData(tempBuildSessionId);
        buildSessionData = this.buildSessionIdProxy.createBuildSession(buildSessionData, null);
        return this.verifyCreateResult(buildSessionData, tempBuildSessionId);
    }

    private long syncBuildSessionData() {
        return TimeClockDispatcher.getInstance(AgentId.getAgentId(), new TimeClockServiceHandler(this.getExecData().getToken(), this.getExecData().getTokenData().getServer(), this.getGeneralParams().getProxy())).getTimeClock();
    }

    private BuildSessionData prepareBuildSessionData(String tempBuildSessionId) {
        BuildSessionData buildSessionData = new BuildSessionData(this.getGeneralParams().getAppName(), this.buildNameResolver.resolveBuildName(this.getGeneralParams().getBuild(), this.syncBuildSessionData()), this.getGeneralParams().getBranch(), tempBuildSessionId, new AdditionalArgumentsData(this.getGeneralParams().getPackagesIncluded(), this.getGeneralParams().getPackagesExcluded()));
        buildSessionData.setCustomerId(this.getExecData().getCustomerId());
        return buildSessionData;
    }

    private BuildSessionData verifyCreateResult(BuildSessionData buildSessionData, String tempBuildSessionId) {
        if (buildSessionData == null) {
            return (BuildSessionData)this.setFailure("Failed to create build session id on server");
        }
        if (tempBuildSessionId != null) {
            this.getGoalLogger().info("Build session was created with provided buildSessionId:'{}'", (Object)tempBuildSessionId);
        }
        return buildSessionData;
    }

    private BuildSessionData resolveExistingBuildSession(String inputBuildSessionId) {
        if (inputBuildSessionId != null) {
            return this.getBuildSessionDataFromServer(inputBuildSessionId);
        }
        String labId = this.getLabId();
        if (StringUtils.isNotEmpty(labId)) {
            return this.resolveBuildSessionByLabId(labId);
        }
        this.setFailure(String.format("cannot resolve build-session-id from provided params buildSessionId:'%s', buildSessionIdFile:'%s', labId:'%s'", this.getGeneralParams().getBuildSessionId(), this.getGeneralParams().getBuildSessionIdFile(), labId));
        return null;
    }

    private BuildSessionData resolveBuildSessionByLabId(String labId) {
        BuildSessionData buildSessionData = this.labIdsProxy.getBuildSessionData(labId);
        return this.validBSDataOrNull(buildSessionData);
    }

    private String getLabId() {
        return this.getGeneralParams().getLabId();
    }

    private BuildSessionData getBuildSessionDataFromServer(String tempBuildSessionId) {
        this.getGoalLogger().info("Getting provided buildSessionId:'{}' data from server", (Object)tempBuildSessionId);
        BuildSessionData buildSessionData = this.buildSessionIdProxy.getBuildSessionData(tempBuildSessionId);
        return this.validBSDataOrNull(buildSessionData);
    }

    private void warnIfInputOverridden(BuildSessionData buildSessionData) {
        this.warnIfInputParamOverridden(this.getGeneralParams().getAppName(), buildSessionData.getAppName(), APP_NAME);
        this.warnIfInputParamOverridden(this.getGeneralParams().getBuild(), buildSessionData.getBuildName(), BUILD);
        this.warnIfInputParamOverridden(this.getGeneralParams().getBranch(), buildSessionData.getBranchName(), BRANCH);
        if (buildSessionData.getPullRequestParams() != null) {
            PullRequestParams prParam = buildSessionData.getPullRequestParams();
            this.warnIfInputParamOverridden(this.getGeneralParams().getRepositoryUrl(), prParam.getRepositoryUrl(), REPOSITORY_URL);
            this.warnIfInputParamOverridden(Integer.toString(this.getGeneralParams().getPullRequestNumber()), Integer.toString(prParam.getPullRequestNumber()), PULL_REQUEST_NUMBER);
            this.warnIfInputParamOverridden(this.getGeneralParams().getLatestCommit(), prParam.getLatestCommit(), LATEST_COMMIT);
            this.warnIfInputParamOverridden(this.getGeneralParams().getTargetBranch(), prParam.getTargetBranch(), TARGET_BRUNCH);
        }
        if (buildSessionData.getAdditionalParams() != null) {
            this.warnIfInputParamOverridden(this.getGeneralParams().getPackagesIncluded(), buildSessionData.getAdditionalParams().getPackagesIncluded(), PACKAGES_INCLUDED);
        }
    }

    private void warnIfInputParamOverridden(String inputParam, String buildSessionValue, String paramName) {
        if (StringUtils.isNotEmpty(inputParam) && !inputParam.equals(buildSessionValue)) {
            this.getGoalLogger().warn("*** build-session parameter '{}'='{}' overrides input '{}'", new Object[]{paramName, buildSessionValue, inputParam});
        }
    }

    private boolean isValidCreationData() {
        return this.assertParameterValue(this.getGeneralParams().getAppName(), APP_NAME, CREATE_BUILD_SESSION_ID) && this.assertParameterValue(this.getGeneralParams().getBuild(), BUILD, CREATE_BUILD_SESSION_ID) && this.assertParameterValue(this.getGeneralParams().getBranch(), BRANCH, CREATE_BUILD_SESSION_ID) && this.assertPackagesIncludedValid(this.getGeneralParams().getPackagesIncluded());
    }

    private boolean isValidPullRequestBSIDCreationData() {
        return this.assertParameterValue(this.getGeneralParams().getAppName(), APP_NAME, CREATE_PR_BUILD_SESSION_ID) && this.assertParameterValue(this.getGeneralParams().getRepositoryUrl(), REPOSITORY_URL, CREATE_PR_BUILD_SESSION_ID) && this.assertParameterValue(Integer.toString(this.getGeneralParams().getPullRequestNumber()), PULL_REQUEST_NUMBER, CREATE_PR_BUILD_SESSION_ID) && this.assertParameterValue(this.getGeneralParams().getLatestCommit(), LATEST_COMMIT, CREATE_PR_BUILD_SESSION_ID) && this.assertParameterValue(this.getGeneralParams().getTargetBranch(), TARGET_BRUNCH, CREATE_PR_BUILD_SESSION_ID) && this.assertPackagesIncludedValid(this.getGeneralParams().getPackagesIncluded());
    }

    private boolean assertParameterValue(String value, String name, String scope) {
        if (StringUtils.isNullOrEmpty(value)) {
            this.setFailure(String.format("'%s' was set, but '%s' was not provided.", scope, name));
            return false;
        }
        return true;
    }

    private BuildSessionData validBSDataOrNull(BuildSessionData buildSessionData) {
        if (this.isValidBSData(buildSessionData)) {
            return buildSessionData;
        }
        return null;
    }

    private boolean isValidBSData(BuildSessionData buildSessionData) {
        if (buildSessionData == null) {
            this.setFailure("Failed to get build session data from server.");
            return false;
        }
        if (this.getGeneralParams().isRunFunctionalTests()) {
            return this.isValidBSDataForFunctionalTests(buildSessionData);
        }
        return this.isValidFullBSData(buildSessionData);
    }

    private boolean isValidFullBSData(BuildSessionData buildSessionData) {
        return this.assertBuildSessionDataProperty(buildSessionData.getAppName(), APP_NAME) && this.assertBuildSessionDataProperty(buildSessionData.getBuildName(), BUILD) && this.assertBuildSessionDataProperty(buildSessionData.getBranchName(), BRANCH) && this.assertAdditionalParamsNotNull(buildSessionData.getAdditionalParams()) && this.assertPackagesIncludedValid(buildSessionData.getAdditionalParams().getPackagesIncluded());
    }

    private boolean assertAdditionalParamsNotNull(AdditionalArgumentsData additionalParams) {
        if (additionalParams == null) {
            this.setFailure("received build session data without 'packagesIncluded' ('additionalInfo'='null')");
            return false;
        }
        return true;
    }

    private boolean isValidBSDataForFunctionalTests(BuildSessionData buildSessionData) {
        return this.assertBuildSessionDataProperty(buildSessionData.getAppName(), APP_NAME) && this.assertBuildSessionDataProperty(buildSessionData.getBuildName(), BUILD) && this.assertBuildSessionDataProperty(buildSessionData.getBranchName(), BRANCH);
    }

    private boolean assertBuildSessionDataProperty(String value, String name) {
        if (StringUtils.isNullOrEmpty(value)) {
            this.setFailure(String.format("received build session data with empty value of '%s'", name));
            return false;
        }
        return true;
    }

    private boolean assertPackagesIncludedValid(String packagesIncluded) {
        ValidationResult result = this.packagesIncludedValidator.validate(packagesIncluded);
        for (String errorMsg : result.getErrors()) {
            this.setFailure(errorMsg);
        }
        return result.isValid();
    }

    @Generated
    public BuildSessionServiceProxy getBuildSessionIdProxy() {
        return this.buildSessionIdProxy;
    }

    @Generated
    public LabIdsServiceProxy getLabIdsProxy() {
        return this.labIdsProxy;
    }

    @Generated
    public PackagesIncludedValidator getPackagesIncludedValidator() {
        return this.packagesIncludedValidator;
    }

    @Generated
    public BuildNameResolver getBuildNameResolver() {
        return this.buildNameResolver;
    }

    @Generated
    public void setBuildSessionIdProxy(BuildSessionServiceProxy buildSessionIdProxy) {
        this.buildSessionIdProxy = buildSessionIdProxy;
    }

    @Generated
    public void setLabIdsProxy(LabIdsServiceProxy labIdsProxy) {
        this.labIdsProxy = labIdsProxy;
    }

    @Override
    @Generated
    public String toString() {
        return "InitBuildSessionIdProc(buildSessionIdProxy=" + this.getBuildSessionIdProxy() + ", labIdsProxy=" + this.getLabIdsProxy() + ", packagesIncludedValidator=" + this.getPackagesIncludedValidator() + ", buildNameResolver=" + this.getBuildNameResolver() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitBuildSessionIdProc)) {
            return false;
        }
        InitBuildSessionIdProc other = (InitBuildSessionIdProc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuildSessionServiceProxy this$buildSessionIdProxy = this.getBuildSessionIdProxy();
        BuildSessionServiceProxy other$buildSessionIdProxy = other.getBuildSessionIdProxy();
        if (this$buildSessionIdProxy == null ? other$buildSessionIdProxy != null : !this$buildSessionIdProxy.equals(other$buildSessionIdProxy)) {
            return false;
        }
        LabIdsServiceProxy this$labIdsProxy = this.getLabIdsProxy();
        LabIdsServiceProxy other$labIdsProxy = other.getLabIdsProxy();
        if (this$labIdsProxy == null ? other$labIdsProxy != null : !this$labIdsProxy.equals(other$labIdsProxy)) {
            return false;
        }
        PackagesIncludedValidator this$packagesIncludedValidator = this.getPackagesIncludedValidator();
        PackagesIncludedValidator other$packagesIncludedValidator = other.getPackagesIncludedValidator();
        if (this$packagesIncludedValidator == null ? other$packagesIncludedValidator != null : !this$packagesIncludedValidator.equals(other$packagesIncludedValidator)) {
            return false;
        }
        BuildNameResolver this$buildNameResolver = this.getBuildNameResolver();
        BuildNameResolver other$buildNameResolver = other.getBuildNameResolver();
        return !(this$buildNameResolver == null ? other$buildNameResolver != null : !this$buildNameResolver.equals(other$buildNameResolver));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InitBuildSessionIdProc;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildSessionServiceProxy $buildSessionIdProxy = this.getBuildSessionIdProxy();
        result = result * 59 + ($buildSessionIdProxy == null ? 43 : $buildSessionIdProxy.hashCode());
        LabIdsServiceProxy $labIdsProxy = this.getLabIdsProxy();
        result = result * 59 + ($labIdsProxy == null ? 43 : $labIdsProxy.hashCode());
        PackagesIncludedValidator $packagesIncludedValidator = this.getPackagesIncludedValidator();
        result = result * 59 + ($packagesIncludedValidator == null ? 43 : $packagesIncludedValidator.hashCode());
        BuildNameResolver $buildNameResolver = this.getBuildNameResolver();
        result = result * 59 + ($buildNameResolver == null ? 43 : $buildNameResolver.hashCode());
        return result;
    }
}

