/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.http.api.AgentIdentificationDataHolder;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import io.sealights.plugins.engine.procs.InitAgentsLocationProc;
import io.sealights.plugins.engine.procs.InitBuildSessionIdProc;
import io.sealights.plugins.engine.procs.InitTokenProc;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import io.sealights.plugins.engine.utils.FilesStorageGoalHelper;
import java.util.Map;
import lombok.Generated;

public class InitPluginExecutionProc
extends PluginGoalProc {
    private InitTokenProc initTokenStep;
    private InitBuildSessionIdProc initBuildSessionIdStep;
    private InitAgentsLocationProc initAgentsLocationStep;

    public InitPluginExecutionProc(PluginGoal goal) {
        super(goal);
        this.initTokenStep = new InitTokenProc(goal);
        AgentIdentificationDataHolder.setAgentType(goal.getPluginType().getAgentType().toString());
        this.initBuildSessionIdStep = new InitBuildSessionIdProc(goal);
        this.initAgentsLocationStep = new InitAgentsLocationProc(goal);
    }

    @Override
    public void execute() {
        BuildLifeCycle.initLogger(this.getGoal());
        if (!FilesStorageGoalHelper.validate(this, this.getGeneralParams().getFilesStorage())) {
            return;
        }
        if (this.setJvmProperties() && this.executeSubProc(this.initTokenStep) && this.executeSubProc(this.initBuildSessionIdStep)) {
            BuildLifeCycle.notifyStart(this.getGoal());
            if (this.executeSubProc(this.initAgentsLocationStep)) {
                this.setSuccess();
            }
        }
    }

    private boolean setJvmProperties() {
        Map<String, ?> jvmParams = this.getGeneralParams().getSealightsJvmParams();
        try {
            if (jvmParams != null) {
                for (String propName : jvmParams.keySet()) {
                    Object propValue = jvmParams.get(propName);
                    if (propValue != null) {
                        String strValue = propValue.toString();
                        System.setProperty(propName, strValue);
                        this.getGoalLogger().info("Property '{}' was set to '{}'", (Object)propName, (Object)strValue);
                        continue;
                    }
                    this.getGoalLogger().info("Property '{}' has no value defined", (Object)propName);
                }
            }
            return true;
        }
        catch (Exception e) {
            this.setFailure(String.format("failed to map to sys.properties 'sealightsJvmParams'=%s", jvmParams), e);
            return false;
        }
    }

    @Override
    public String getName() {
        return "InitPluginExecution";
    }

    @Generated
    public InitTokenProc getInitTokenStep() {
        return this.initTokenStep;
    }

    @Generated
    public InitBuildSessionIdProc getInitBuildSessionIdStep() {
        return this.initBuildSessionIdStep;
    }

    @Generated
    public InitAgentsLocationProc getInitAgentsLocationStep() {
        return this.initAgentsLocationStep;
    }

    @Generated
    public void setInitTokenStep(InitTokenProc initTokenStep) {
        this.initTokenStep = initTokenStep;
    }

    @Generated
    public void setInitBuildSessionIdStep(InitBuildSessionIdProc initBuildSessionIdStep) {
        this.initBuildSessionIdStep = initBuildSessionIdStep;
    }

    @Generated
    public void setInitAgentsLocationStep(InitAgentsLocationProc initAgentsLocationStep) {
        this.initAgentsLocationStep = initAgentsLocationStep;
    }

    @Override
    @Generated
    public String toString() {
        return "InitPluginExecutionProc(initTokenStep=" + this.getInitTokenStep() + ", initBuildSessionIdStep=" + this.getInitBuildSessionIdStep() + ", initAgentsLocationStep=" + this.getInitAgentsLocationStep() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitPluginExecutionProc)) {
            return false;
        }
        InitPluginExecutionProc other = (InitPluginExecutionProc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InitTokenProc this$initTokenStep = this.getInitTokenStep();
        InitTokenProc other$initTokenStep = other.getInitTokenStep();
        if (this$initTokenStep == null ? other$initTokenStep != null : !((Object)this$initTokenStep).equals(other$initTokenStep)) {
            return false;
        }
        InitBuildSessionIdProc this$initBuildSessionIdStep = this.getInitBuildSessionIdStep();
        InitBuildSessionIdProc other$initBuildSessionIdStep = other.getInitBuildSessionIdStep();
        if (this$initBuildSessionIdStep == null ? other$initBuildSessionIdStep != null : !((Object)this$initBuildSessionIdStep).equals(other$initBuildSessionIdStep)) {
            return false;
        }
        InitAgentsLocationProc this$initAgentsLocationStep = this.getInitAgentsLocationStep();
        InitAgentsLocationProc other$initAgentsLocationStep = other.getInitAgentsLocationStep();
        return !(this$initAgentsLocationStep == null ? other$initAgentsLocationStep != null : !((Object)this$initAgentsLocationStep).equals(other$initAgentsLocationStep));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InitPluginExecutionProc;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InitTokenProc $initTokenStep = this.getInitTokenStep();
        result = result * 59 + ($initTokenStep == null ? 43 : ((Object)$initTokenStep).hashCode());
        InitBuildSessionIdProc $initBuildSessionIdStep = this.getInitBuildSessionIdStep();
        result = result * 59 + ($initBuildSessionIdStep == null ? 43 : ((Object)$initBuildSessionIdStep).hashCode());
        InitAgentsLocationProc $initAgentsLocationStep = this.getInitAgentsLocationStep();
        result = result * 59 + ($initAgentsLocationStep == null ? 43 : ((Object)$initAgentsLocationStep).hashCode());
        return result;
    }
}

