/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenError;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.util.List;

public class InitTokenProc
extends PluginGoalProc {
    public InitTokenProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public String getName() {
        return "InitToken";
    }

    @Override
    public void execute() {
        String tempToken = ArgumentFileReader.resolve(this.getGeneralParams().getToken(), this.getGeneralParams().getTokenFile());
        if (StringUtils.isNullOrEmpty(tempToken)) {
            this.setFailure("Token is not provided.");
            return;
        }
        TokenData tokenData = TokenParser.parseAndValidate(tempToken);
        if (tokenData.isValid()) {
            this.getExecData().setTokenData(tokenData);
            this.getExecData().setToken(tempToken);
            this.setSuccess();
        } else {
            this.setFailure(this.toStringTokenErrors(tokenData));
        }
    }

    private String toStringTokenErrors(TokenData tokenData) {
        List<TokenError> validationErrors = tokenData.getValidationErrors();
        StringBuilder buf = new StringBuilder();
        if (validationErrors.size() > 0) {
            buf.append("Invalid token. Errors: ");
            for (TokenError err : validationErrors) {
                buf.append(err.toString()).append(" ");
            }
        } else {
            buf.append("Invalid token");
        }
        return buf.toString();
    }
}

