/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.utils.jvm.JvmUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.clibuilders.BldScanrArgsBuilder;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.util.List;

public class RunBldScanrProcMaven
extends PluginGoalProc {
    public RunBldScanrProcMaven(PluginGoal goal) {
        super(goal);
    }

    @Override
    public void execute() {
        this.runScanner();
    }

    @Override
    public String getName() {
        return "Run build-scanner";
    }

    private void runScanner() {
        BldScanrArgsBuilder cliBuilder = new BldScanrArgsBuilder(this.getGoal(), this.getExecData());
        List<String> cli = cliBuilder.execute().asArgsArray();
        if (!this.isValidCli(cli)) {
            this.setFailure("Invalid CLI, cannot run build scanner");
        }
        if (JvmUtils.runNewJvm(cli)) {
            this.setSuccess();
        } else {
            this.setFailure("Failed to run build-scanner for module '" + this.getModuleName() + "'");
        }
    }

    private boolean isValidCli(List<String> cli) {
        if (!cli.get(0).contains("java")) {
            this.setFailure("Java argument is missing");
            return false;
        }
        return true;
    }
}

