/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procs;

import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.plugins.engine.api.DependencyInfo;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import io.sealights.plugins.engine.utils.AnnouncmentFormatter;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class SetupJacocoProc
extends PluginGoalProc {
    public static final String JACOCO_GROUP_ID = "org.jacoco";
    public static final String JACOCO_ARTIFACT_ID = "jacoco-maven-plugin";
    public static final String MIN_JACOCO_VERSION = "0.8.0";
    public static final ComparableVersion BUG_FREE_JACOCO_VERSION = new ComparableVersion("0.8.0");

    public SetupJacocoProc(PluginGoal goal) {
        super(goal);
    }

    @Override
    public String getName() {
        return "SetupJaCoCo";
    }

    @Override
    public void execute() {
        this.disableJaCoCoIfNeeded();
        this.setSuccess();
    }

    public void disableJaCoCoIfNeeded() {
        boolean enableJaCoCO = Boolean.getBoolean("sl.enableJacoco");
        if (enableJaCoCO) {
            return;
        }
        for (DependencyInfo p : this.getProjectDescriptor().getPlugins()) {
            if (!this.isJaCoCoPlugin(p) || !this.shouldIgnoreJaCoCo(p)) continue;
            this.ignoreJaCoCo(p.getVersion());
            this.getProjectDescriptor().getProperties().setProperty("jacoco.skip", "true");
            break;
        }
    }

    private void ignoreJaCoCo(String jacocoVersion) {
        String message = String.format("Ignoring JaCoCo since the current JaCoCo version has a bug which prevents it from working with SeaLights.\nCurrent version:'%s', Minimum JaCoCo version:'%s'.\nFor more information see: https://github.com/jacoco/jacoco/issues/551", jacocoVersion, MIN_JACOCO_VERSION);
        this.getGoalLogger().info(AnnouncmentFormatter.format(Level.INFO.getName(), message));
        this.getProjectDescriptor().getProperties().setProperty("jacoco.skip", "true");
    }

    private boolean shouldIgnoreJaCoCo(DependencyInfo plugin) {
        ComparableVersion currentVersion = new ComparableVersion(plugin.getVersion());
        return BUG_FREE_JACOCO_VERSION.compareTo(currentVersion) > 0;
    }

    private boolean isJaCoCoPlugin(DependencyInfo plugin) {
        return JACOCO_GROUP_ID.equalsIgnoreCase(plugin.getGroupID()) && JACOCO_ARTIFACT_ID.equalsIgnoreCase(plugin.getArtifactID());
    }
}

