/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procsexecutor;

import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginEngine;
import io.sealights.plugins.engine.api.PluginExecResult;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.lifecycle.BuildEndInfo;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import io.sealights.plugins.engine.procs.ExecuteBldScanrGoalProc;
import io.sealights.plugins.engine.procs.ExecutePrelistenerGoalProc;
import io.sealights.plugins.engine.procs.ExecuteTstListnrGoalProc;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;

public class PluginEngineHandler
implements PluginEngine {
    public static String CONSOLE_LOG_TAG = "Sealights Plugin Engine";
    private static ConsoleLogger CONSOLE_LOG;

    public static ConsoleLogger getConsoleLog() {
        return CONSOLE_LOG;
    }

    @Override
    public PluginExecResult executeTstLisnrGoal(PluginGoal tstLisnrGoal) {
        return PluginEngineHandler.executeProcedure(new ExecuteTstListnrGoalProc(tstLisnrGoal), false);
    }

    @Override
    public PluginExecResult executeBldScanrGoal(PluginGoal bldScanrGoal) {
        return PluginEngineHandler.executeProcedure(new ExecuteBldScanrGoalProc(bldScanrGoal), false);
    }

    @Override
    public PluginExecResult executePreLisnrGoal(PluginGoal preLisnrGoal) {
        return PluginEngineHandler.executeProcedure(new ExecutePrelistenerGoalProc(preLisnrGoal), false);
    }

    @Override
    public void notifyBuildEnd(PluginGoal pluginGoal, BuildEndInfo buildEndInfo) {
        BuildLifeCycle.notifyBuildEnd(pluginGoal, buildEndInfo);
    }

    public static PluginExecResult executeProcedure(PluginGoalProc proc, boolean isSubProcedure) {
        try {
            proc.execute();
            PluginExecResult result = proc.getResult();
            if (!result.isOk() && !isSubProcedure) {
                PluginEngineHandler.notifyProcedureError(proc, result.getErrorMsgs().toString());
            }
            return result;
        }
        catch (Exception e) {
            proc.getGoalLogger().error("Module:'{}', unexpected error", (Object)proc.getModuleName(), (Object)e);
            PluginExecResult result = PluginEngineHandler.createFailureResult(proc, e);
            PluginEngineHandler.notifyProcedureError(proc, result.getErrorMsgs().toString());
            return result;
        }
    }

    private static PluginExecResult createFailureResult(PluginGoalProc proc, Exception e) {
        PluginExecResult result = new PluginExecResult();
        String error = StringUtils.isNotEmpty(e.getMessage()) ? e.getMessage() : (e.getCause() != null ? e.getCause().toString() : "Unhandled error");
        result.setFailure(error);
        return result;
    }

    private static void notifyProcedureError(PluginGoalProc proc, String error) {
        String notification = String.format("Module:'%s', failed execute %s, error:'%s'", proc.getModuleName(), proc.getGoal().getName(), error);
        BuildLifeCycle.notifyError(notification);
        proc.getGoalLogger().error(notification);
    }

    static {
        ConsoleLogger.initComponentTag(CONSOLE_LOG_TAG);
        CONSOLE_LOG = LogFactory.createConsoleLogger();
    }
}

