/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.procsexecutor;

import io.sealights.plugins.engine.api.PluginExecData;
import io.sealights.plugins.engine.api.PluginExecResult;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.api.PluginParameters;
import io.sealights.plugins.engine.api.ProjectDescriptor;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;
import io.sealights.plugins.engine.procsexecutor.PluginEngineHandler;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class PluginGoalProc {
    private PluginGoal goal;
    private PluginExecResult result = new PluginExecResult();

    public PluginGoalProc(PluginGoal goal) {
        this.goal = goal;
    }

    public void setSuccess() {
        this.result.setOk();
    }

    public void setResultFailure() {
        this.result.setFailure();
    }

    public void setResultFailure(String msg) {
        this.result.setFailure(msg);
    }

    public void setResultFailure(Throwable e) {
        this.result.setFailure(e.toString());
    }

    public <T> T setFailure(String msg) {
        this.setResultFailure(msg);
        return null;
    }

    public <T> T setFailure(String msg, Exception e) {
        this.result.setFailure(msg, e);
        return null;
    }

    public PluginParameters getParams() {
        return this.goal.getParams();
    }

    public PluginParameters.GeneralParams getGeneralParams() {
        return this.getParams().getGeneralParams();
    }

    public PluginParameters.BldScanrParams getBldScanrParams() {
        return this.getParams().getBldScanrParams();
    }

    public PluginParameters.TstLisnrParams getTstLisnrParams() {
        return this.getParams().getTstListnrParams();
    }

    public Logger getGoalLogger() {
        return this.goal.getLogger();
    }

    public String getModuleName() {
        return this.goal.getModuleName();
    }

    public ProjectDescriptor getProjectDescriptor() {
        return this.getExecData().getProjectDescriptor(this.getModuleName());
    }

    protected PluginExecData getExecData() {
        return BuildLifeCycle.getExecData();
    }

    protected boolean executeSubProc(PluginGoalProc subProc) {
        PluginExecResult tempResult = PluginEngineHandler.executeProcedure(subProc, true);
        if (tempResult.isOk()) {
            return true;
        }
        this.result.setFailure(tempResult.getErrorMsgs());
        return false;
    }

    public abstract void execute();

    public abstract String getName();

    @Generated
    public PluginGoal getGoal() {
        return this.goal;
    }

    @Generated
    public PluginExecResult getResult() {
        return this.result;
    }

    @Generated
    public void setGoal(PluginGoal goal) {
        this.goal = goal;
    }

    @Generated
    public void setResult(PluginExecResult result) {
        this.result = result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginGoalProc)) {
            return false;
        }
        PluginGoalProc other = (PluginGoalProc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PluginGoal this$goal = this.getGoal();
        PluginGoal other$goal = other.getGoal();
        if (this$goal == null ? other$goal != null : !this$goal.equals(other$goal)) {
            return false;
        }
        PluginExecResult this$result = this.getResult();
        PluginExecResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginGoalProc;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PluginGoal $goal = this.getGoal();
        result = result * 59 + ($goal == null ? 43 : $goal.hashCode());
        PluginExecResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginGoalProc(goal=" + this.getGoal() + ", result=" + this.getResult() + ")";
    }
}

