/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.utils;

import io.sealights.onpremise.agents.infra.logging.Level;
import java.util.HashMap;

public class AnnouncmentFormatter {
    private static final String STAR = "*";
    private static final String NEW_LINE = "\n";
    private static final HashMap<String, Integer> logLevelToLength = new HashMap();
    private static final String logLevelFormat = "[%s] ";

    public static String format(String level, String message) {
        String[] lines = message.split(NEW_LINE);
        StringBuilder buffer = new StringBuilder();
        int lengthOfLongestLine = AnnouncmentFormatter.getLengthOfLongestLine(lines);
        int separatorLength = lengthOfLongestLine + 4;
        AnnouncmentFormatter.appendSeparator(0, separatorLength, buffer);
        int logLevelLength = logLevelToLength.get(level);
        for (int i = 0; i < lines.length; ++i) {
            AnnouncmentFormatter.appendLinePrefix(logLevelLength, buffer);
            String line = lines[i];
            buffer.append(line);
            AnnouncmentFormatter.verifyLineHasConstantLength(lengthOfLongestLine, buffer, line);
            AnnouncmentFormatter.appendLineSuffix(buffer);
        }
        AnnouncmentFormatter.appendSeparator(logLevelLength, separatorLength, buffer);
        return buffer.toString();
    }

    private static void appendLineSuffix(StringBuilder buffer) {
        buffer.append(" ");
        buffer.append(STAR);
        buffer.append(NEW_LINE);
    }

    private static void appendLinePrefix(int logLevelLength, StringBuilder buffer) {
        AnnouncmentFormatter.addPadding(logLevelLength, buffer);
        buffer.append(STAR);
        buffer.append(" ");
    }

    private static int getLengthOfLongestLine(String[] lines) {
        int separatorLength = 0;
        for (String l : lines) {
            if (separatorLength >= l.length()) continue;
            separatorLength = l.length();
        }
        return separatorLength;
    }

    private static void verifyLineHasConstantLength(int separatorLength2, StringBuilder buffer, String l) {
        if (l.length() < separatorLength2) {
            int diff = separatorLength2 - l.length();
            AnnouncmentFormatter.addPadding(diff, buffer);
        }
    }

    private static void addPadding(int padding, StringBuilder buffer) {
        for (int i = 0; i < padding; ++i) {
            buffer.append(" ");
        }
    }

    private static void appendSeparator(int padding, int maxSize, StringBuilder buffer) {
        if (padding > 0) {
            AnnouncmentFormatter.addPadding(padding, buffer);
        }
        for (int i = 0; i < maxSize; ++i) {
            buffer.append(STAR);
        }
        buffer.append(NEW_LINE);
    }

    static {
        logLevelToLength.put(Level.DEBUG.getName(), String.format(logLevelFormat, Level.DEBUG.getName()).length());
        logLevelToLength.put(Level.INFO.getName(), String.format(logLevelFormat, Level.INFO.getName()).length());
        logLevelToLength.put(Level.WARN.getName(), String.format(logLevelFormat, Level.WARN.getName()).length());
        logLevelToLength.put(Level.ERROR.getName(), String.format(logLevelFormat, Level.WARN.getName()).length());
    }
}

