/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.plugins.engine.utils;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.plugins.engine.api.PluginGoal;
import io.sealights.plugins.engine.procsexecutor.PluginGoalProc;
import java.io.File;
import java.nio.file.Paths;
import lombok.Generated;

public final class FilesStorageGoalHelper {
    public static String normalizeFilesStorage(PluginGoal pluginGoal, String filesStorage) {
        if (StringUtils.isNullOrEmpty(filesStorage)) {
            pluginGoal.getLogger().info(String.format("Empty filesStorage is set to default: %s", System.getProperty("java.io.tmpdir")));
            return System.getProperty("java.io.tmpdir");
        }
        if (Paths.get(filesStorage, new String[0]).isAbsolute()) {
            pluginGoal.getLogger().info(String.format("Using provided filesStorage(absolute path): %s", filesStorage));
            return filesStorage;
        }
        File filesStorageFile = new File(filesStorage);
        String absolutePath = filesStorageFile.getAbsolutePath();
        pluginGoal.getLogger().info(String.format("Relative filesStorage [%s] changed to absolute path: %s", filesStorage, absolutePath));
        return absolutePath;
    }

    public static boolean validate(PluginGoalProc pluginGoalProc, String filesStorage) {
        if (StringUtils.isNullOrEmpty(filesStorage)) {
            pluginGoalProc.setFailure("Provided filesStorage parameter is invalid(empty), should be absolute path");
            return false;
        }
        if (!Paths.get(filesStorage, new String[0]).isAbsolute()) {
            pluginGoalProc.setFailure(String.format("Provided filesStorage parameter is invalid(relative path): %s, should be absolute path", filesStorage));
            return false;
        }
        return true;
    }

    @Generated
    private FilesStorageGoalHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

