package io.sealights.onpremise.agents.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.maven.project.MavenProject;

import io.sealights.onpremise.agents.plugin.surefire.PluginsHandler;
import lombok.Getter;
import org.slf4j.Logger;

/**
 * Encapsulates data of the whole maven session, which is shared by all sub-projects
 * 
 * @author AlaSchneider
 *
 */
public enum MavenSessionExtension {
	INSTANCE;
	
	@Getter
	// Map key is a sub-project name
	private Map<String, PluginsHandler> testPluginsHandlers = new ConcurrentHashMap<>();
	
	public PluginsHandler getOrCreateTestPluginsHandler(MavenProject project, Logger logger) {
		if (!testPluginsHandlers.containsKey(project.getName())) {
			testPluginsHandlers.put(project.getName(), new PluginsHandler(project, logger));
		}
		// The map is synchronized, since sub-projects may be built in parallel.
		// The value does not demands synchronization, since a sub-project mojos are executed serially.
		return testPluginsHandlers.get(project.getName());
	}
}
