package io.sealights.onpremise.agents.plugin;

import java.util.Map;

import org.apache.maven.plugins.annotations.Mojo;

import io.sealights.onpremise.agents.infra.constants.SLProperties;
import io.sealights.plugins.engine.api.PluginParameters.TstLisnrParams;
import io.sealights.plugins.engine.lifecycle.BuildLifeCycle;

/**
 * Runs the Test Listener.
 *
 * @phase generate-sources
 * @goal test-listener
 * @threadSafe
 * @since 1.0.0
 */
@Mojo(name = "listener")
public class TstListnrMojo extends SeaLightsMojo {

    /**
     * Flag to enable/disable Test Listener.
     *
     * @parameter property="testListenerEnabled" default-value="true"
     */
	private boolean testListenerEnabled;

    /**
     * Path to the Test Listener configuration file.
     *
     * @parameter property="testListenerConfigFile"
     */
	private String testListenerConfigFile;

    /**
     * Jvm params for testListener.
     *
     * @parameter property="testListenerJvmParams"
     *
     * */
	private Map<String,?> testListenerJvmParams;

    /**
     * Class loaders to be excluded.
     *
     * @parameter property="classLoadersExcluded"
     */
	private String classLoadersExcluded;

    /**
     * Force this plugin to create the test listener in this path.
     *
     * @parameter property="overrideTestListenerPath"
     */
	private String overrideTestListenerPath;
    
	/**
	 * Flag to disable test listener logs in spite of common logEnabled=true
	 *
	 * @parameter property="testListenerIgnoreLogEnabled" default-value="false"
	 */
    private boolean testListenerIgnoreLogEnabled;
    
	@Override
	public void initParams() {
		super.initParams();
		TstLisnrParams tstListnrParams = new TstLisnrParams();
		tstListnrParams.setTestListenerEnabled(testListenerEnabled);
		tstListnrParams.setTestListenerConfigFile(testListenerConfigFile);
		tstListnrParams.setTestListenerJvmParams(testListenerJvmParams);
		tstListnrParams.setClassLoadersExcluded(classLoadersExcluded);
		tstListnrParams.setTestListenerIgnoreLogEnabled(testListenerIgnoreLogEnabled);
		getParams().setTstListnrParams(tstListnrParams);
	}

	@Override
	protected boolean executePluginGoal() {
		boolean result = getPluginEngine().executeTstLisnrGoal(this).isOk();
		// Configuration is initialized and validated in initGoalInternals
		return result;
	}
	
	@Override
	public void onFailure() {
		super.onFailure();
		final String error = String.format("module:'%s' - test-istener was not configured due to invalid surefire configuration", getModuleName());
		BuildLifeCycle.notifyError(error);
		getLogger().warn(error);
	}

	@Override
	public boolean postExecute() {
		if (isRunScanOnly()) {
			return true;
		}

		if (getPluginsHandler().isValidConfiguration()) {
			setTstLsnrPathSysProperty();
			getPluginsHandler().updateProperties(
					getExecData().getTstLisnrCliData(getModuleName()).getMavenPluginTstLisnrCli(),
					getExecData().getToken(),
					true);
			return testListenerEnabled;
		}
		else {
			return false;
		}
	}
    
	@Override
	protected String getMojoName() {
		return "test listener";
	}
	
	private void setTstLsnrPathSysProperty(){
		if(getProject() != null && getProject().getProperties() != null) {
			getProject().getProperties().setProperty(SLProperties.PATH_TO_TEST_LISTENER, getExecData().getTstLisnrLocation());
		}
	}
}
